<?php
namespace boru\dhutils\traits;

use \boru\dhutils\dhGlobal;

trait GetSetArray {
    protected $GetSetMainArray = "data";
    protected $GetSetSeparator = ".";

    protected function getSetInit($arr=null,$separator=".") {
        $this->setGetSetSeparator($separator);
        if(is_array($arr) && !empty($arr)) {
            foreach($arr as $k=>$v) {
                $this->set($k,$v);
            }
        }
    }

    public function set($key,$val="",$append=false) {
        $arr = $this->GetSetMainArray;
        $this->setArray($this->$arr,$key,$val,$append);
        return $this;
    }
    public function get($key=null,$default=null) {
        $arr = $this->GetSetMainArray;
        return $this->getArray($this->$arr,$key,$default);
    }
    public function exists($key=null) {
        $arr = $this->GetSetMainArray;
        return $this->existsArray($this->$arr,$key);
    }
    public function remove($key) {
        $arr = $this->GetSetMainArray;
        unset($this->$arr[$key]);
        return $this;
    }
    
    public function setArray(&$array,$key,$val="",$append=false) {
        if(strpos($key,$this->GetSetSeparator) !== false) {
            if($append) {
                $check = dhGlobal::getDot($array,$key,$this->GetSetSeparator);
                if(!is_null($check)) {
                    if(is_array($check)) {
                        $check[] = $val;
                        $val = $check;
                    } else {
                        $narr = [];
                        $narr[] = $check;
                        $narr[] = $val;
                        $val = $narr;
                    }
                }
            }
            dhGlobal::dotAssign($array,$key,$val);
        }
        else {
            if(isset($array[$key]) && $append) {
                if(is_array($array[$key])) {
                    $array[$key][] = $val;
                } else {
                    $temp = $array[$key];
                    $array[$key] = [];
                    $array[$key][] = $temp;
                    $array[$key][] = $val;
                }
            } else {
                $array[$key] = $val;
            }
        }
        return $this;
    }
    
    public function getArray($array,$key=null,$default=null,$exists=false) {
        if(is_null($key)) {
            if($exists) {
                return !empty($array) ? true : false;
            } else {
                return !empty($array) ? $array : $default;
            }
        }
        if(strpos($key,$this->GetSetSeparator) !== false) {
            $uniqueid = uniqid("getArray",true);
            if(($check = dhGlobal::getDot($array,$key,$uniqueid,$this->GetSetSeparator)) !== $uniqueid) {
                return $exists ? true : $check;
            };
        }
        if($exists) {
            return isset($array[$key]);
        } else {
            return isset($array[$key]) ? $array[$key] : $default;
        }
        
    }

    public function existsArray($array,$key) {
        return $this->getArray($array,$key,null,true);
    }

    /**
     * Get the value of GetSetSeparator
     */ 
    public function getGetSetSeparator()
    {
        return $this->GetSetSeparator;
    }

    /**
     * Set the value of GetSetSeparator
     *
     * @return  self
     */ 
    public function setGetSetSeparator($GetSetSeparator)
    {
        $this->GetSetSeparator = $GetSetSeparator;

        return $this;
    }

    /**
     * Get the value of GetSetMainArray
     */ 
    public function getGetSetMainArray()
    {
        return $this->GetSetMainArray;
    }

    /**
     * Set the value of GetSetMainArray
     *
     * @return  self
     */ 
    public function setGetSetMainArray($GetSetMainArray)
    {
        $this->GetSetMainArray = $GetSetMainArray;

        return $this;
    }
}