<?php
namespace boru\dhutils\traits;

use \boru\dhutils\dhGlobal;
use \boru\dhutils\dhOut;
use \boru\dhutils\logger\Handler;

trait GlobalLogHandler {
    /**
     * Access to the global Logger instance.
     * @see: \boru\dhutils\Logger - for information about the various logging levels.
     * defaults:
     * * trace: 500
     * * debug: 400
     * * info: 300
     * * warn: 200
     * * error: 100
     * * off: 0
     * @return Handler
     */
    public static function logHandler() {
        $logHandler = static::get("logHandler",false);
        if($logHandler === false) {
            $logHandler = new Handler();
            static::add("logHandler",$logHandler);
        }
        $logHandler = static::get("logHandler",false);
        return $logHandler;
    }
    public static function log(...$args) {
        return static::logHandler()->log(...$args);
    }
    public static function trace(...$args) {
        return static::logHandler()->trace(...$args);
    }
    public static function debug(...$args) {
        return static::logHandler()->debug(...$args);
    }
    public static function info(...$args) {
        return static::logHandler()->info(...$args);
    }
    public static function warn(...$args) {
        return static::logHandler()->warn(...$args);
    }
    public static function error(...$args) {
        return static::logHandler()->error(...$args);
    }
    public static function logger($name,$levels=dhGlobal::LOG_ERROR,$stdOut=true,$file=false,$lineSeperator=PHP_EOL) {
        return static::logHandler()->logger($name,$levels,$stdOut,$file,$lineSeperator);
    }
    /**
     * Add a level to the logger.
     * 
     * Example:
     * 
     * dhGlobal::addLogLevel("query","QUERY","debug") -- adds a 'query' level to the debug log display
     * 
     * @param string $name the name of the level used for logging (eg: $logger->log($name,stuff,to,print))
     * @param string $level level to add the new level to, ['trace','debug','info','warn','error']
     * @param string $prefix optional prefix used if different from the name. 5 characters
     * @return boolean true if successful, false if failed
     */
    public static function addLogLevel($name,$level,$prefix=null) {
        return static::logHandler()->defineLogLevel($name,$level,$prefix);
    }
    public static function defineLogLevel($name,$level,$prefix=null) {
        return static::logHandler()->defineLogLevel($name,$level,$prefix);
    }
}