<?php

use boru\dhutils\async\Queue;
use boru\dhutils\async\Work;
use boru\dhutils\dhGlobal;

require dirname(__FILE__)."/../init.php";

dhGlobal::outLine("Running async/Queue test(s)");
dhGlobal::asyncVisualize(true);
$numToRun = 7;
$queue = new Queue(3);
$callable = ["static","exec"];
$args = ["ping google.com -c 2"];
for($i=0;$i<$numToRun;$i++) {
    $work = new Work($callable,["asJson"=>true,"args"=>$args]);
    $work->onQueued(function($work) use ($i) {
        dhGlobal::outLine("Queued $i");
    });
    $work->onStart(function($work) use ($i) {
        dhGlobal::outLine("Started $i");
    });
    $work->then(function($result) use ($i) {
        dhGlobal::outLine("Work finished for $i");
    },function($e) use ($i) {
        dhGlobal::outLine("Work failed for $i");
    });
    $queue->queue($work);
}