<?php

use boru\dhutils\async\Queue;
use boru\dhutils\async\Result;
use boru\dhutils\async\Work;
use boru\dhutils\dhGlobal;
use React\EventLoop\Loop;

require dirname(__FILE__)."/../init.php";
//dhGlobal::logger("debugger",dhGlobal::LOG_ALL,true,false);

dhGlobal::outLine("Running async test(s) using multiple work groups");

$queue = new Queue(8,__DIR__."/bootstrap/class.php",null,true);
$queue->setMaxQueued(10)->enableExtendedBar(true);

dhGlobal::outLine("starting queue process.. ");
$numToRun = 50;
$groups = 12;
$callable = ["AsyncBootstrapTest","run"];

//Setup the groups
$numPerGroup = ceil($numToRun/$groups);
$groupNum=0;
$groupCounter=0;
for($i=0;$i<$groups;$i++) {
    $groupIdentifier = "group".$i;
    $queue->createWorkGroup($groupIdentifier)->then(function($gid) {
        Queue::display("complete","*** GROUP:".$gid);
    },function($gid) {
        Queue::display("error","*** GROUP:".$gid);
    });
}

//run the queue
for($i=0;$i<$numToRun;$i++) {
    $groupCounter++;
    if($groupCounter>$numPerGroup) {
        $groupNum++;
        $groupCounter=0;
    }
    $identifier = "g".$groupNum."-".$i;
    $groupIdentifier = "group".$groupNum;
    $work = Queue::callableWork($callable,$groupIdentifier."_".$i,0,5)
        ->setMetaData("name",$identifier);
    Queue::basicDisplay($work,$identifier);
    $queue->queue($work,$groupIdentifier);
}
$queue->wait();
dhGlobal::debug("other stuff");
Loop::run();