<?php
require dirname(__FILE__)."/../vendor/autoload.php";
use \boru\dhutils\dhGlobal;
use \boru\dhutils\dhThreads;
use \boru\dhutils\filesys\File;

/**
 * output logging
 */

//uncomment this line if you want to include Trace messages (a lot of them)..
//dhGlobal::logger("debugger",dhGlobal::LOG_ALL,true,false);
//use this line for standard usage
dhGlobal::logger("debugger",dhGlobal::LOG_ALL & ~dhGlobal::LOG_TRACE,true,false);

//maxThreads = 5 -- up to 5 commands can run at a time
$maxThreads = 5;
//throttleDelay = 0.5 -- half-second delay between checking if we can spin up another thread once we hit maxThreads running threads
$throttleDelay = 0.5;
//Number of threads to test with
$threads = 10;

//init the threadpool
$threadPool = new dhThreads($maxThreads,$throttleDelay);

//Simple output class to show the thread progress
$simpleOut = new simpleOutput($threads);

//register with dhGlobal
dhGlobal::set("simpleOut",$simpleOut);

/**
 * Thread options.. 
 * valid options are
 * json - boolean - if true, parses thread output as JSON
 * jsonObject - boolean - if true, parses thread output as JSON in Object output form
 * callback - callable - optional callback to trigger on completion of each thread
 * 
 * Note: output parsing is only available if php-Memcached is enabled and the server has Memcached installed.
 * see class dhCache for more information on that extension
 */
$options = [
    "json"=>true,
    "jsonObject"=>false,
    "callback"=>function($thread) {
        $simpleOut = dhGlobal::get("simpleOut");
        $simpleOut->done($thread->id());
        $simpleOut->display();
        //dhGlobal::outLine($thread->id(),"Completed");
        //dhGlobal::outLine($thread->id(),$thread->meta());
        //dhGlobal::outLine($thread->id(),$thread->output());
    }
];

/**
 * The script to execute.. note that this is just a sample script that will sleep for a random time
 * in order to show it is multi-threaded
 */
$script = new File(["path"=>"dhThreads/exec.php"]);



//push $threads commands through our threadpool..
for($i=0;$i<$threads;$i++) {
    $randStart = rand(1,3);
    $randEnd = $randStart+3;
    $threadPool->startScript($script,["randStart"=>$randStart,"randEnd"=>$randEnd],$options);
}
echo "Now waiting..\n";
//wait for all threads to complete
$threadPool->wait();

class simpleOutput {
    public $threads = [];
    public $done = 0;
    public $total = 0;
    public function __construct($threads=10) {
        $this->total = $threads;
        $this->done = 0;
        for($i=0;$i<$threads;$i++) {
            $this->threads[$i] = ".";
        }
    }
    public function display() {
        $percent = $this->done / $this->total;
        $percent *= 100;
        dhGlobal::outLine(implode(" ",$this->threads)." ".dhGlobal::pad(number_format($percent,2),7," ",STR_PAD_LEFT));
    }
    public function done($i) {
        $this->done++;
        $this->threads[$i] = 'x';
    }
}

