<?php
require dirname(__FILE__)."/../vendor/autoload.php";
use \boru\dhutils\dhGlobal;
use \boru\dhutils\dhThreads;
use \boru\dhutils\filesys\File;

/**
 * output logging
 */

//uncomment this line if you want to include Trace messages (a lot of them)..
//dhGlobal::logger("debugger",dhGlobal::LOG_ALL,true,false);
//use this line for standard usage
dhGlobal::logger("debugger",dhGlobal::LOG_ALL & ~dhGlobal::LOG_TRACE,true,false);

//maxThreads = 5 -- up to 5 commands can run at a time
$maxThreads = 20;
//throttleDelay = 0.5 -- half-second delay between checking if we can spin up another thread once we hit maxThreads running threads
$throttleDelay = 0.1;
//Number of threads to test with
$threads = 20;

//Simple output class to show the thread progress
$simpleOut = new simpleOutput($threads);

//register with dhGlobal
dhGlobal::set("simpleOut",$simpleOut);

/**
 * Thread options.. 
 * valid options are
 * json - boolean - if true, parses thread output as JSON
 * jsonObject - boolean - if true, parses thread output as JSON in Object output form
 * callback - callable - optional callback to trigger on completion of each thread
 * 
 * Note: output parsing is only available if php-Memcached is enabled and the server has Memcached installed.
 * see class dhCache for more information on that extension
 */
$options = [
    "json"=>true,
    "jsonObject"=>false,
    "callback"=>function($thread) {
        $simpleOut = dhGlobal::get("simpleOut");
        $simpleOut->done($thread->id());
        $simpleOut->display();
        //dhGlobal::outLine($thread->id(),$thread->command());
        //dhGlobal::outLine($thread->id(),$thread->meta());
        //dhGlobal::outLine($thread->id(),$thread->output());
    },
    "collectType"=>dhThreads::COLLECT_FULL,
];

/**
 * Build an array of commands to execute
 */
$commands = [];
for($i=0;$i<$threads;$i++) {
    $randStart = rand(1,3);
    $randEnd = $randStart+3;
    $commands[] = [
        "exec"=>"php -f ".__DIR__."/dhThreads/exec.php inline $randStart $randEnd",
        "meta"=>["randomData"=>"toInclude","someval"=>$i,"randStart"=>$randStart,"randEnd"=>$randEnd],
    ];
}
$output = dhGlobal::threadMultiExec($commands,$options,$maxThreads,$throttleDelay);

/**
 * global methods to wrap all of dhThreads_class example using just dhGlobal
 */

//Using threadMultiExec
//dhGlobal::threadMultiExec($commands=[],$options=[],$numThreads=4,$throttleDelay=0.1)



class simpleOutput {
    public $threads = [];
    public function __construct($threads=10) {
        for($i=0;$i<$threads;$i++) {
            $this->threads[$i] = ".";
        }
    }
    public function display() {
        dhGlobal::outLine(implode(" ",$this->threads));
    }
    public function done($i) {
        $this->threads[$i] = 'x';
    }
}
