<?php
namespace boru\dhutils;

use boru\dhutils\dhGlobal;
use React\EventLoop\Loop;

class QueueBot {

    private static $getNextItem = null;
    private static $handleItem = null;
    private static $interval = 10;

    private static $started = false;
    private static $isPaused = false;

    /**
     * 
     * @param callable $getNextItem 
     * @param callable $handleItem 
     * @param float $interval (default: 10) seconds between getNextItem calls
     * @param bool $debug (default: false) if true, log to console
     * @param bool $start (default: false) if true, start the event loop
     * @return void 
     */
    public function init($getNextItemCallback=null,$handleItemCallback=null,$interval=10,$start=false) {
        if(!is_null($getNextItemCallback)) {
            static::setGetNextItemCallback($getNextItemCallback);
        }
        if(!is_null($handleItemCallback)) {
            static::setHandleItemCallback($handleItemCallback);
        }
        static::setInterval($interval);
        
        if ($start) {
            static::start();
        }
    }

    public static function start($interval=null) {
        if(!static::$started) {
            static::_log("starting");
            static::_addTimer($interval);
            static::$started = true;
            Loop::run();
        }
        static::$isPaused = false;
    }
    public static function resume() {
        static::_log("resuming");
        static::$isPaused = false;
    }
    public static function pause() {
        static::_log("pausing");
        static::$isPaused = true;
    }

    public static function isPaused() {
        return static::$isPaused;
    }

    public static function setCallbacks($getNextItemCallback,$handleItemCallback) {
        static::setGetNextItemCallback($getNextItemCallback);
        static::setHandleItemCallback($handleItemCallback);
    }
    public static function setGetNextItemCallback($getNextItemCallback) {
        static::$getNextItem = $getNextItemCallback;
    }
    public static function setHandleItemCallback($handleItemCallback) {
        static::$handleItem = $handleItemCallback;
    }
    public static function setInterval($interval) {
        static::$interval = $interval;
    }

    private static function _getNextItem() {
        $getNextItem = static::$getNextItem;
        return $getNextItem();
    }
    private static function _handleItem($item) {
        $handleItem = static::$handleItem;
        $handleItem($item);
    }

    
    public static function _log(...$message) {
        array_unshift($message,"QueueBot:");
        dhGlobal::debug(...$message);
    }

    private static function _addTimer($interval=null) {
        if (is_null($interval)) {
            $interval = static::$interval;
        }
        Loop::addPeriodicTimer($interval, function () {
            if(QueueBot::isPaused()) {
                QueueBot::_log("paused");
                return;
            }
            //QueueBot::_log("checking for work");
            $item = QueueBot::_getNextItem();
            if ($item) {
                QueueBot::_log("handling an item");
                QueueBot::_handleItem($item);
            }
        });
        static::_log("loop initialized");
    }
}