<?php
namespace boru\dhutils\async;

use boru\dhutils\base\dhObject;
use boru\dhutils\dhGlobal;

class Result extends dhObject {
    private $workId;
    private $isError=false;
    public function __construct($data=[],$workId=null,$isError=false) {
        parent::__construct($data);
        $this->workId = $workId;
        $this->isError = $isError;
    }
    public function isError() {
        return $this->isError;
    }
    public function id() {
        return $this->workId;
    }
    public function result($dotKey=null,$default=null) {
        if(is_null($dotKey)) {
            return $this->get("result",$default);
        }
        $newKey = "result.".$dotKey;
        return $this->get($newKey,$default);
    }
    public function error($dotKey=null,$default=null) {
        if(is_null($dotKey)) {
            return $this->get("error",$default);
        }
        $newKey = "error.".$dotKey;
        return $this->get($newKey,$default);
    }

    /**
	 * Get the value of workId
     * @return  mixed
     */
    public function getWorkId() {
        return $this->workId;
    }

    /**
     * Set the value of workId
     * @param   mixed  $workId  
     * @return  self
	 */
    public function setWorkId($workId) {
        $this->workId = $workId;
        return $this;
    }
}