<?php
namespace boru\dhutils\base;

use \boru\dhutils\dhGlobal;

class Args {
    public $argstring = "";
    public $args = [];
    public $argsUsed = [];
    public $options = [];

    public $cursor = 0;

    public function __construct($args=[],$options=["separator"=>" "]) {
        $separator = dhGlobal::getVal($options,"separator"," ");
        if(!is_array($args)) {
            $this->args = explode($separator,$args);
        } else {
            $this->args = $args;
        }
    }

    public function shift() {
        if(!$this->hasNext()) {
            return false;
        }
        return array_shift($this->args);
    }
    public function next() {
        if(!$this->hasNext()) {
            return false;
        }
        return $this->args[$this->cursor++];
    }
    public function peek($num) {
        $num-=1;
        return isset($this->args[$this->cursor+$num]) ? $this->args[$this->cursor+$num] : false;
    }
    public function markUsed($peek=false) {
        $num = $this->cursor;
        $num-=1;
        if($peek!==false) {
            $num+=$peek;
        }
        $this->argsUsed[$num]=true;
    }
    public function hasNext() {
        return isset($this->args[$this->cursor]);
    }

    public function isLongArg($arg) {
        //print_r($arg);
        if($arg[0] == "-" && $arg[1] == "-" && !empty($arg[2])) {
            return true;
        }
        return false;
    }
    public function isShortArg($arg) {
        if($arg[0] == "-" && $arg[1] != "-" && !empty($arg[1])) {
            return true;
        }
        return false;
    }

    public function isValue($arg) {
        return !$this->isArg($arg);
    }
    public function isArg($arg) {
        if($this->isLongArg($arg) || $this->isShortArg($arg)) {
            return true;
        }
        return false;
    }
    
    public function getArgValue($arg) {
        if($this->isShortArg($arg)) {
            $o = substr($arg,1);
            if(strlen($o)<=1) {
                $peek = $this->peek(1);
                if($peek === false || $this->isArg($peek)) {
                    return false;
                }
                $this->markUsed(1);
                return $peek;
            } else {
                return substr($o,1);
            }
        } elseif($this->isLongArg($arg)) {
            $o = substr($arg,2);
            $p = strpos($o, '=');
            if($p) {
                return substr($o, $p+1);
            } else {
                $peek = $this->peek(1);
                if($peek === false || $this->isArg($peek)) {
                    return false;
                }
                $this->markUsed(1);
                return $peek;
            }
        }
        return false;
    }
    public function getArgs($includeUsed=false) {
        if($includeUsed) {
            return $this->args;
        } else {
            $args = $this->args;
            foreach($this->argsUsed as $k=>$v) {
                unset($args[$k]);
            }
            return array_values($args);
        }
    }
}