<?php
namespace boru\dhutils;

use boru\dhutils\http\Client;
use Exception;
use InvalidArgumentException;
use React\Http\Browser;
use React\Promise\PromiseInterface;
use Throwable;
use UnexpectedValueException;

/** Async HTTP Wrapper (React) */
class dAsyncHttp {

    /** @var \React\Http\Browser */
    protected static $browser;
    protected static $isInit = false;
    public static $maxResponseSize = 1024*1024*50; //50MB

    public static function client($options=[]) {
        $instance = new Client($options);
        return $instance;
    }
    /**
     * 
     * @param mixed $promise 
     * @return mixed 
     * @throws Exception 
     * @throws Throwable 
     * @throws UnexpectedValueException 
     */
    public static function await($promise) {
        return \React\Async\await($promise);
    }
    /**
     * 
     * @return void 
     */
    public static function init($force=false,$browser=null) {
        if(!static::$isInit || $force) {
            static::$isInit = true;
            if(!is_null($browser)) {
                static::$browser = $browser;
            } else {
                static::$browser = new Browser();
                static::$browser = static::$browser->withResponseBuffer(static::$maxResponseSize);
            }
        }
    }
    /**
     * 
     * @param mixed $url 
     * @param array $headers 
     * @param callable|null $onSuccess 
     * @param callable|null $onError 
     * @return \React\Promise\ExtendedPromiseInterface 
     * @throws InvalidArgumentException 
     */
    public static function get($url,$headers=[],callable $onSuccess=null,callable $onError=null,$timeout=true) {
        static::init();
        if(is_null($headers)) {
            $headers = [];
        }
        $successCallback = static::makeSuccessCallback($url,"get",$onSuccess);
        $errorCallback = static::makeErrorCallback($url,"get",$onError);
        return static::$browser->withTimeout($timeout)->get($url,$headers)->then($successCallback, $errorCallback);
    }
    /**
     * 
     * @param mixed $url 
     * @param array $headers 
     * @param string $body 
     * @param callable|null $onSuccess 
     * @param callable|null $onError 
     * @return \React\Promise\PromiseInterface 
     * @throws InvalidArgumentException 
     */
    public static function post($url,$headers=[],$body='',callable $onSuccess=null,callable $onError=null,$timeout=true) {
        static::init();
        $successCallback = static::makeSuccessCallback($url,"post",$onSuccess);
        $errorCallback = static::makeErrorCallback($url,"post",$onError);
        if(is_array($body)) {
            $body = json_encode($body);
        }
        return static::$browser->withTimeout($timeout)->post($url,$headers,$body)->then($successCallback, $errorCallback);
    }
    /**
     * 
     * @param mixed $url 
     * @param array $headers 
     * @param string $body 
     * @param callable|null $onSuccess 
     * @param callable|null $onError 
     * @return \React\Promise\PromiseInterface 
     * @throws InvalidArgumentException 
     */
    public static function put($url,$headers=[],$body='',callable $onSuccess=null,callable $onError=null,$timeout=true) {
        static::init();
        $successCallback = static::makeSuccessCallback($url,"put",$onSuccess);
        $errorCallback = static::makeErrorCallback($url,"put",$onError);
        if(is_array($body)) {
            $body = json_encode($body);
        }
        return static::$browser->withTimeout($timeout)->put($url,$headers,$body)->then($successCallback, $errorCallback);
    }
    /**
     * 
     * @param mixed $url 
     * @param array $headers 
     * @param string $body 
     * @param callable|null $onSuccess 
     * @param callable|null $onError 
     * @return \React\Promise\PromiseInterface 
     * @throws InvalidArgumentException 
     */
    public static function patch($url,$headers=[],$body='',callable $onSuccess=null,callable $onError=null,$timeout=true) {
        static::init();
        $successCallback = static::makeSuccessCallback($url,"patch",$onSuccess);
        $errorCallback = static::makeErrorCallback($url,"patch",$onError);
        if(is_array($body)) {
            $body = json_encode($body);
        }
        return static::$browser->withTimeout($timeout)->patch($url,$headers,$body)->then($successCallback, $errorCallback);
    }
    /**
     * 
     * @param mixed $url 
     * @param array $headers 
     * @param string $body 
     * @param callable|null $onSuccess 
     * @param callable|null $onError 
     * @return \React\Promise\PromiseInterface 
     * @throws InvalidArgumentException 
     */
    public static function delete($url,$headers=[],$body='',callable $onSuccess=null,callable $onError=null,$timeout=true) {
        static::init();
        $successCallback = static::makeSuccessCallback($url,"delete",$onSuccess);
        $errorCallback = static::makeErrorCallback($url,"delete",$onError);
        if(is_array($body)) {
            $body = json_encode($body);
        }
        return static::$browser->withTimeout($timeout)->delete($url,$headers,$body)->then($successCallback, $errorCallback);
    }
    /**
     * 
     * @param mixed $url 
     * @param array $headers 
     * @param callable|null $onSuccess 
     * @param callable|null $onError 
     * @return \React\Promise\PromiseInterface 
     * @throws InvalidArgumentException 
     */
    public static function head($url,$headers=[],callable $onSuccess=null,callable $onError=null,$timeout=true) {
        static::init();
        $successCallback = static::makeSuccessCallback($url,"head",$onSuccess);
        $errorCallback = static::makeErrorCallback($url,"head",$onError);
        return static::$browser->withTimeout($timeout)->head($url,$headers)->then($successCallback, $errorCallback);
    }
    /**
     * 
     * @param mixed $method 
     * @param mixed $url 
     * @param array $headers 
     * @param mixed $body 
     * @param callable|null $onSuccess 
     * @param callable|null $onError 
     * @return \React\Promise\PromiseInterface 
     * @throws InvalidArgumentException 
     */
    public static function request($method,$url,$headers=[],$body,callable $onSuccess=null,callable $onError=null,$timeout=true) {
        static::init();
        $successCallback = static::makeSuccessCallback($url,$method,$onSuccess);
        $errorCallback = static::makeErrorCallback($url,$method,$onError);
        if(is_array($body)) {
            $body = json_encode($body);
        }
        return static::$browser->withTimeout($timeout)->request($method,$url,$headers,$body)->then($successCallback, $errorCallback);
    }

    //aliases

    protected static function makeSuccessCallback($url,$method,callable $callback=null) {
        return function (\Psr\Http\Message\ResponseInterface $response) use($callback,$url,$method) {
            $resp = new \boru\dhutils\guzzle\Response($response);
            if(is_callable($callback)) {
                return $callback($resp);
            } else {
                dhGlobal::info("Unhandled dAHttp response from",$method,$url);
                return $resp;
            }
        };
    }
    protected static function makeErrorCallback($url,$method,callable $callback=null) {
        return function (\Exception $e) use ($callback,$url,$method) {
            if(is_callable($callback)) {
                return $callback($e);
            } else {
                dhGlobal::error('Uncaught dAHttp Error from',$method,$url,":",$e->getMessage());
                return $e;
            }
        };
    }
}