<?php
namespace boru\dhutils;

use \boru\dhutils\dhGlobal;
use boru\dhutils\guzzle\Request;
use Psr\Http\Message\ResponseInterface;
use GuzzleHttp\Exception\GuzzleException;

/**
 * Guzzle HTTP Wrapper
 * @package boru\dhutils
 */
class dhHttp {
    //set these with global calls
    public static $retryLimit = 5;
    public static $retryDelay = 5;
    public static $clientOptions = ["exceptions"=>true];

    protected $client;
    protected $options;
    protected $response;

    protected $url;
    protected $method;

    public $debug_prefix = "dhHttp:: ";
    public $debugDoTrace = false;
    public $doDebug = false;

    /**
     * 
     * @param mixed $request 
     * @param array $options 
     * @return \boru\dhutils\guzzle\Response 
     * @throws GuzzleException 
     */
    public function send($request,$options=[]) {
        $method = $request->getMethod();
        $url = $request->getUrl();
        if(!empty($options)) {
            $request->replace($options);
        }
        $this->debug("Sending $method to $url");
        $guzzleRequest = new \GuzzleHttp\Psr7\Request(strtoupper($method),$url);
        $tries = 0;
        $this->response = $this->client->send($guzzleRequest,$request->get());
        while($this->response->getStatusCode() >= 500 && $tries < static::$retryLimit) {
            sleep(static::$retryDelay);
            $tries++;
            $this->debug("(retry $tries of ".static::$retryLimit.") Sending $method to $url");
            $this->response = $this->client->send($guzzleRequest,$request->get());
        }
        return $this->response;
    }
  
    public function __construct($method="",$url="",$options=[]) {
        $stack = new \GuzzleHttp\HandlerStack();
        $stack->setHandler(new \GuzzleHttp\Handler\CurlHandler());
        $stack->push(\GuzzleHttp\Middleware::mapResponse(function (\Psr\Http\Message\ResponseInterface $response) {
            return new \boru\dhutils\guzzle\Response($response);  
        }));
        if(empty($options)) {
            $clientOpts = static::$clientOptions;
        } else {
            if(isset($options["trace"])) {
                $this->debugDoTrace = $options["trace"];
                $this->doDebug = true;
                unset($options["trace"]);
            } elseif(isset($options["debug"])) {
                $this->doDebug = true;
            }
            $clientOpts = $options;
        }
        $clientOpts["handler"] = $stack;
        $this->client = new \GuzzleHttp\Client($clientOpts);
        if(!empty($method)) {
            $this->setMethod($method);
        }
        if(!empty($url)) {
            $this->setUrl($url);
        }
    }
    protected function debug(...$args) {
        if($this->doDebug) {
            array_unshift($args,$this->debug_prefix." - ");
            $level = $this->debugDoTrace ? "trace" : "debug";
            array_unshift($args,$level);
            return call_user_func_array([$this,"log"],$args);
        }
    }
    public function log(...$args) {
        return dhGlobal::log(...$args);
    }

    /**
     * 
     * @param mixed $method 
     * @param mixed $url 
     * @param array $options 
     * @return Request 
     */
    public function request($method, $url, $options=[]) {
        return new \boru\dhutils\guzzle\Request($method,$url,$options,$this);
    }

    /**
     * Get the value of url
     */ 
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * Set the value of url
     *
     * @return  self
     */ 
    public function setUrl($url)
    {
        $this->url = $url;

        return $this;
    }

    /**
     * Get the value of method
     */ 
    public function getMethod()
    {
        return $this->method;
    }

    /**
     * Set the value of method
     *
     * @return  self
     */ 
    public function setMethod($method)
    {
        $this->method = $method;

        return $this;
    }

    /**
     * Get the value of options
     */ 
    public function getOptions()
    {
        return $this->options;
    }

    /**
     * Set the value of options
     *
     * @return  self
     */ 
    public function setOptions($options)
    {
        $this->options = $options;

        return $this;
    }
}