<?php
namespace boru\dhutils;

class dhImage {
    public static function mergeFiles($maxFiles=2,...$files,$outputDir=null) {
        if(!$outputDir) {
            $outputDir = __DIR__.'/';
        }
        if(isset($files[0]) && is_array($files[0])) {
            $files = $files[0];
        }
        if(count($files) <= $maxFiles || count($files) < 2 || !is_numeric($maxFiles)) {
            return $files;
        }
        //We will put the two images side by side.. reducing the number by 50% on each iteration.
        $firstFile = "";
        $firstI = 0;
        $newIndex = 0;
        foreach($files as $i=>$file) {
            //on each even iteration, we set the first file
            if($i % 2 == 0) {
                //echo "Setting first file to $file\n";
                $firstFile = $file;
                $firstI = $i;
                continue;
            }

            $newImage = static::doMerge($firstFile,$file);
            $outFile = $outputDir.($i+1).'-c-'.rand().'.webp';
            $newImage->writeImage($outFile);
            $outputFiles[] = [
                "file"=>$outFile,
                "width"=>$newImage->getImageWidth(),
                "height"=>$newImage->getImageHeight(),
            ];
            unlink($firstFile);
            unlink($file);
            unset($files[$firstI]);
            unset($files[$i]);
        }
        if(count($outputFiles) > 0) {
            if(!empty($files)) {
                foreach($files as $i=>$file) {
                    $outputFiles[] = [
                        "file"=>$file,
                        "width"=>$newImage->getImageWidth(),
                        "height"=>$newImage->getImageHeight(),
                    ];
                }
            }
            if(count($outputFiles) > $maxFiles) {
                static::mergeFiles($maxFiles);
            }
        }
        return $outputFiles;
    }
    private static function doMerge($firstFile,$secondFile) {
        $image1 = new \Imagick($firstFile);
        $image2 = new \Imagick($secondFile);

        $newImage = new \Imagick();
        $newImage->newImage($image1->getImageWidth() + $image2->getImageWidth(), max($image1->getImageHeight(),$image2->getImageHeight()), new \ImagickPixel('transparent'), 'webp');
        $newImage->compositeImage($image1->getImage(), \Imagick::COMPOSITE_COPY, 0, 0);
        $newImage->compositeImage($image2->getImage(), \Imagick::COMPOSITE_COPY, $image1->getImageWidth(), 0);
        return $newImage;
    }
}