<?php
namespace boru\dhutils\filesys;

use \boru\dhutils\filesys\File;
use \boru\dhutils\dhGlobal;
use \boru\dhutils\base\dhObject;

class ConfigFile extends dhObject implements \JsonSerializable {
    protected $data = null;
    protected $prettyJson = true;
    protected $sort = true;
    /** @var File */
    protected $file;
    public function __construct($options=[]) {
        if(($fileopt = dhGlobal::getVal($options,"file",null)) === null) {
            if(($fileopt = dhGlobal::getVal($options,"fileName",null)) === null) {
                if(($fileopt = dhGlobal::getVal($options,"path",null)) === null) {
                    throw new \Exception("ConfigFile requires a file ,fileName or path defined");
                }
            }
        }
        if(!is_object($fileopt)) {
            $this->file = new File(["path"=>$fileopt,"create"=>true]);
        } else {
            $this->file = $fileopt;
        }
        $this->prettyJson = dhGlobal::getVal($options,"prettyJson",true);
        $this->sort = dhGlobal::getVal($options,"sort",true);

        $this->load();
    }

    public function load() {
        $content = $this->file->content(["json"=>true]);
        $this->data = [];
        if(is_array($content) && !empty($content)) {
            if($this->sort) {
                ksort($this->data);
            }
            foreach($content as $k=>$v) {
                $this->set($k,$v);
            }
        }
        return $this;
    }
    public function save() {
        if($this->sort) {
            ksort($this->data);
        }
        if($this->prettyJson) {
            $this->file->write(json_encode($this,JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES));
        } else {
            $this->file->write(json_encode($this,JSON_UNESCAPED_SLASHES));
        }
        return $this;
    }
    public static function loadFile($file) {
        $config = new ConfigFile(["file"=>$file]);
        $config->load();
        return $config;
    }
}