<?php
namespace boru\dhutils\http;

class Request extends \boru\dhutils\base\dhObject {
    public $data = [];

    protected $parent;
    protected $url;
    protected $method;

    public function __construct($method="",$url="",$opts=[],&$parent=null) {
        parent::__construct($opts);
        if(!is_null($parent)) {
            $this->parent = &$parent;
        }
        if(!empty($method)) {
            $this->setMethod($method);
        }
        if(!empty($url)) {
            $this->setUrl($url);
        }
    }

    /**
     * 
     * @return \boru\dhutils\guzzle\Response 
     */
    public function send() {
        return $this->parent->send($this);
    }
    public function run() {
        return $this->send();
    }

    public function replace($opts=[]) {
        $this->data = $opts;
    }

    protected function mset($primary,$key,$value=null,$append=false) {
        if(is_array($key) && is_null($value)) {
            foreach($key as $k=>$v) {
                $this->set($primary.".".$k,$v,$append);        
            }
        } else {
            $this->set($primary.".".$key,$value,$append);
        }
    }
    public function auth($user,$pass) {
        $this->set(\GuzzleHttp\RequestOptions::AUTH,[$user,$pass]);
        return $this;
    }
    public function authBasic($user,$pass) {
        $this->set(\GuzzleHttp\RequestOptions::AUTH,[$user,$pass]);
        return $this;
    }
    public function authToken($token) {
        $this->mset(\GuzzleHttp\RequestOptions::HEADERS,"Authorization",$token);
        return $this;
    }
    public function authBearer($token) {
        $this->mset(\GuzzleHttp\RequestOptions::HEADERS,"Authorization","Bearer ".$token);
        return $this;
    }
    public function header($key,$value) {
        $this->mset(\GuzzleHttp\RequestOptions::HEADERS,$key,$value);
        return $this;
    }
    public function json($key,$value=null) {
        $this->mset(\GuzzleHttp\RequestOptions::JSON,$key,$value);
        return $this;
    }
    public function rawBody($body) {
        $this->set(\GuzzleHttp\RequestOptions::BODY,$body);
        return $this;
    }
    public function body($key,$value=null) {
        if(is_null($value)) {
            return $this->rawBody($key);
        }
        $this->mset(\GuzzleHttp\RequestOptions::BODY,$key,$value);
        return $this;
    }
    public function debug($value=true) {
        $this->set(\GuzzleHttp\RequestOptions::DEBUG,$value);
        return $this;
    }
    public function ipResolve($value="ipv4") {
        $this->set(\GuzzleHttp\RequestOptions::FORCE_IP_RESOLVE,$value);
        return $this;
    }
    public function form($key,$value=null) {
        $this->mset(\GuzzleHttp\RequestOptions::FORM_PARAMS,$key,$value);
        return $this;
    }
    public function multipart($value) {
        $mp = $this->get(\GuzzleHttp\RequestOptions::MULTIPART,[]);
        $mp[] = $value;
        $this->set(\GuzzleHttp\RequestOptions::MULTIPART,$mp);
        return $this;
    }
    public function query($key,$value=null) {
        $this->mset(\GuzzleHttp\RequestOptions::QUERY,$key,$value);
        return $this;
    }
    public function sink($value) {
        $this->set(\GuzzleHttp\RequestOptions::SINK,$value);
        return $this;
    }
    public function stream($value=true) {
        $this->set(\GuzzleHttp\RequestOptions::STREAM,$value);
        return $this;
    }
    public function verify($value=false) {
        $this->set(\GuzzleHttp\RequestOptions::VERIFY,$value);
        return $this;
    }

    public function timeout($value=0) {
        $this->set(\GuzzleHttp\RequestOptions::TIMEOUT,$value);
        return $this;
    }

    /**
     * Get the value of parent
     */ 
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Set the value of parent
     *
     * @return  self
     */ 
    public function setParent($parent)
    {
        $this->parent = &$parent;

        return $this;
    }

    /**
     * Get the value of method
     */ 
    public function getMethod()
    {
        return $this->method;
    }

    /**
     * Set the value of method
     *
     * @return  self
     */ 
    public function setMethod($method)
    {
        $this->method = $method;

        return $this;
    }

    /**
     * Get the value of url
     */ 
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * Set the value of url
     *
     * @return  self
     */ 
    public function setUrl($url)
    {
        $this->url = $url;

        return $this;
    }
}