<?php
namespace boru\dhutils\http;

class Response extends \boru\dhutils\base\dhObject implements \Psr\Http\Message\ResponseInterface {
    protected $response;

    private $bodyString;

    private $container;

    public function __construct(\Psr\Http\Message\ResponseInterface $response,$extraAttributes=[]) {
        $this->response = $response;
        $this->container = new \boru\dhutils\base\dhObject($extraAttributes);
    }

    public function code() {
        return $this->getStatusCode();
    }
    public function phrase() {
        return $this->getReasonPhrase();
    }
    public function header($header=null,$default=false) {
        if(is_null($header)) {
            return $this->getHeaders();
        }
        if(!$this->hasHeader($header)) {
            return $default;
        }
        return $this->getHeader($header);
    }
    public function headerLine($header,$default=false) {
        if(!$this->hasHeader($header)) {
            return $default;
        } else {
            return $this->getHeaderLine($header);
        }
    }
    public function attr($attr,$default=false) {
        return $this->container->get($attr,$default);
    }
    public function attrib($attr,$default=false) {
        return $this->container->get($attr,$default);
    }
    public function attribute($attr,$default=false) {
        return $this->container->get($attr,$default);
    }
    public function setAttr($attr,$val) {
        $this->container->set($attr,$val);
        return $this;
    }

    /**
     * 
     * @param bool $json 
     * @param bool $arr 
     * @return mixed 
     */
    public function body($json=false,$arr=true) {
        if($json) {
            return json_decode($this->asString(),$arr);
        } else {
            return $this->asString();
        }
    }

    public function asString() {
        if(is_null($this->bodyString)) {
            $this->bodyString = (string) $this->getBody()->__toString();
        }
        return $this->bodyString;
    }
    public function asArray() {
        return $this->body(true);
    }
    public function asObject() {
        return $this->body(true,false);
    }
    

    //ResponseInterface methods:
    public function getStatusCode() {
        return $this->response->getStatusCode();
    }
    public function withStatus($code, $reasonPhrase = '') {
        return $this->response->getStatusCode($code, $reasonPhrase);
    }
    public function getReasonPhrase() {
        return $this->response->getReasonPhrase();
    }
    public function getProtocolVersion() {
        return $this->response->getProtocolVersion();
    }
    public function withProtocolVersion($version) {
        return $this->response->withProtocolVersion($version);
    }
    public function getHeaderLine($name) {
        return $this->response->getHeaderLine($name);
    }
    public function withHeader($name, $value) {
        return $this->response->withHeader($name, $value);
    }
    public function withAddedHeader($name, $value) {
        return $this->response->withAddedHeader($name, $value);
    }
    public function withoutHeader($name) {
        return $this->response->withoutHeader($name);
    }
    public function hasHeader($header) {
        return $this->response->hasHeader($header);
    }
    public function getHeader($header) {
        return $this->response->getHeader($header);
    }
    public function getHeaders() {
        return $this->response->getHeaders();
    }
    public function getBody() {
        return $this->response->getBody();
    }
    public function withBody(\Psr\Http\Message\StreamInterface $body) {
        return $this->response->withBody($body);
    }
}