<?php
namespace boru\dhutils\httplite\client;

use \boru\dhutils\dhGlobal;

class Params extends \boru\dhutils\base\dhObject {
    protected $data;
    protected $format = "raw"; //raw, json, form, url, header
    public function __construct($format="array") {
        $this->data = [];
        if(!empty($format)) {
            $this->format($format);
        }
    }

    public function getAll($format="") {
        if(empty($format)) {
            $format = $this->format;
        }
        if($format == "json") {
            return json_encode($this->data);
        } elseif($format == "url" || $format == "form") {
            return http_build_query($this->data);
        } elseif($format == "header") {
            $d = [];
            foreach($this->data as $k=>$v) {
                $d[] = $k.": ".$v;
            }
            return $d;
        } else {
            return $this->data;
        }
    }

    public function format($format) {
        $this->format = $format;
    }
    public function pos() {
        return count($this->data);
    }
    
    public static function fromArray($array,$format="form") {
        $params = new self($format);
        if($format == "header" && !dhGlobal::isAssoc($array)) {
            foreach($array as $k=>$v) {
                $temp = explode(": ",$v,2);
                if(count($temp)==2) {
                    $v = isset($temp[1]) ? $temp[1] : "";
                    $params->set($temp[0],$v);
                } else {
                    $params->set($k,$v);
                }
            }
        } else {
            foreach($array as $k=>$v) {
                $params->set($k,$v);
            }
        }
        return $params;
    }
    public static function fromJSON($json,$format="form") {
        $array = json_decode($json,true);
        self::FromArray($array,$format);
    }
    
    /**
     * Header param specifc shortcut for making auth easy
     */
    public function auth($type="Basic",...$params) {
        $token = "";
        $parts = $params;
        if(!empty($type)) {
            array_unshift($parts,$type);
        }
        switch(strtolower($type)) {
            case "basic":
                if(count($params)===1) {
                    $token = "Basic ".$params[0];
                }
                if(count($params)==2) {
                    $token = "Basic ".base64_encode(implode(":",$params));
                }
                break;
            default: 
                $token = implode(" ",$parts);
                break;
        }
        $this->set("Authorization",$token);
    }

    private function isNumericArray($arr) {
        foreach($arr as $k=>$v) {
            if($k !== (int) $k) {
                return false;
            }
        }
        return true;
    }
}