<?php
namespace boru\dhutils\httplite\client;

use \boru\dhutils\dhGlobal;
use \boru\dhutils\httplite\client\Params;
use \boru\dhutils\httplite\client\Response;

class Request {
    protected $headers;
    protected $params;
    protected $url;
    protected $method;
    protected $sslVerify=true;
    protected $verbose=false;
    protected $response;
    protected $auth;
    protected $returnType = "object";
    protected $bodyType = "form";
    protected $expect;

    public function header($headers=[],$val=null) {
        if(is_object($headers)) {
            $this->headers = $headers;
        } elseif(is_array($headers)) {
            $this->headers = Params::fromArray($headers,"header");
        } else {
            if(is_null($this->headers)) {
                $this->headers = new Params("header");
            }
            $this->headers->set($headers,$val);
        }
        return $this;
    }
    public function param($params=[],$val=null) {
        if(is_object($params)) {
            $this->params = $params;
        } elseif(is_array($params)) {
            $this->params = Params::fromArray($params,$this->bodyType);
        } else {
            if(is_null($this->params)) {
                $this->params = new Params($this->bodyType);
            }
            $this->headers->set($params,$val);
        }
        return $this;
    }
    public function url($url) {
        $this->url = $url;
        return $this;
    }
    public function method($method) {
        $this->method = $method;
        return $this;
    }
    public function sslVerify($sslVerify) {
        $this->sslVerify = $sslVerify;
        return $this;
    }
    public function verbose($verbose) {
        $this->verbose = $verbose;
        return $this;
    }
    public function returnType($type=false) {
        $this->returnType = $type;
        return $this;
    }
    public function sendType($type="json") {
        $this->bodyType = $type;
        return $this;
    }
    public function sendJson() {
        $this->bodyType = "json";
        return $this;
    }
    public function sendForm() {
        $this->bodyType = "form";
        return $this;
    }
    public function auth($type="Basic",...$params) {
        $token = "";
        $parts = $params;
        if(!empty($type)) {
            array_unshift($parts,$type);
        }
        switch(strtolower($type)) {
            case "basic":
                if(count($params)===1) {
                    $token = "Basic ".$params[0];
                }
                if(count($params)==2) {
                    $token = "Basic ".base64_encode(implode(":",$params));
                }
                break;
            default: 
                $token = implode(" ",$parts);
                break;
        }
        $this->header("Authorization",$token);
    }
    public function call() {
        if(is_null($this->headers)) {
            $this->headers = new Params("header");
        }
        if(is_null($this->params)) {
            $this->params = new Params("form");
        }
        $ch = curl_init();
        $url = $this->url;
        curl_setopt($ch, CURLOPT_URL, $url);
        if($this->verbose === true) {
            curl_setopt($ch, CURLOPT_VERBOSE, $this->verbose);
        }
        curl_setopt($ch, CURLOPT_HTTPHEADER, $this->headers->getAll());
		curl_setopt($ch, CURLOPT_HEADER,true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, $this->sslVerify);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        switch(strtoupper($this->method)) {
			case 'GET':
					curl_setopt($ch, CURLOPT_CUSTOMREQUEST, strtoupper($this->method));
                if(!empty($this->params)) {
					curl_setopt($ch, CURLOPT_POSTFIELDS, $this->params->getAll());
				}
				break;
			case 'POST':
				curl_setopt($ch, CURLOPT_POST, true);
                if(!empty($this->params)) {
				    curl_setopt($ch, CURLOPT_POSTFIELDS, $this->params->getAll());
                }
				break;
			case 'DELETE':
            case 'PUT':
            case 'OPTIONS':
			default:
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, strtoupper($this->method));
                if(!empty($this->params)) {
				    curl_setopt($ch, CURLOPT_POSTFIELDS, $this->params->getAll());
                }
		}

        dhGlobal::log("info","dhHttp request to ".$url." started");
        $timingStart = microtime(true);
        $response  = curl_exec($ch);
        $timingEnd = microtime(true);
        $timingExec = $timingEnd - $timingStart;
        if(curl_errno($ch)){
            $this->setResponse([
                "error"=>curl_errno($ch),
                "message"=>curl_error($ch),
                "code"=>-1,
                "headers"=>null,
                "body"=>null,
                "execTime"=>$timingExec
            ]);
        } else {
            $info = curl_getinfo($ch);
            curl_close($ch);
            $this->setResponse([
                    "error"=>false,
                    "message"=>false,
                    "code"=>$info["http_code"],
                    "headers"=>trim(substr($response,0,$info['header_size'])),
                    "body"=>substr($response,$info['header_size']),
                    "execTime"=>$timingExec
            ]);
            
        }
        return $this->getResponse();
    }

    /**
     * Get the value of response
     */ 
    public function getReturnType()
    {
        return $this->returnType;
    }

    /**
     * Set the value of response
     *
     * @return  self
     */ 
    public function setReturnType($returnType)
    {
        $this->returnType = $returnType;

        return $this;
    }

    /**
     * Get the value of response
     */ 
    public function getResponse($type=null)
    {
        if(is_null($this->response)) {
            return false;
        }
        if(is_null($type)) {
            $type = $this->returnType;
        }
        if($type == "object") {
            if($this->response["error"]!==false) {
                $resp = new Response($this->response["code"],null,null,$this->response["execTime"]);
                $resp->setErrorCode($this->response["error"]);
                $resp->setErrorMessage($this->response["message"]);
            } else {
                return new Response($this->response["code"],$this->response["headers"],$this->response["body"],$this->response["execTime"]);
            }
        } else {
            return $this->response;
        }
    }

    /**
     * Set the value of response
     *
     * @return  self
     */ 
    public function setResponse($response)
    {
        $this->response = $response;

        return $this;
    }

    /**
     * Get the value of headers
     */ 
    public function getHeaders()
    {
        if(is_object($this->headers)) {
            return $this->headers->getAll();
        }
        return $this->headers;
    }

    /**
     * Get the value of params
     */ 
    public function getParams($json=false)
    {
        if(is_object($this->params)) {
            return $json ? json_encode($this->params->getAll()) : $this->params->getAll();
        }
        return $json ? json_encode($this->params) : $this->params;
    }
}