<?php
/**
 * psr-4 autoloader to bootstrap dhutils classes
 */
spl_autoload_register(function ($class) {
    // project-specific namespace prefix
    if(__psr4Bootstrap_dhutils($class) !== true) {
        if(__psr4Bootstrap_dhcache($class) !== true) {
            return;
        }
    }
    return true;
});
function __psr4Bootstrap_dhutils($class) {
    $prefix = 'boru\\dhutils\\';

    // base directory for the namespace prefix
    $base_dir = __DIR__ . '/../';

    // does the class use the namespace prefix?
    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        // no, move to the next registered autoloader
        return;
    }

    // get the relative class name
    $relative_class = substr($class, $len);

    // replace the namespace prefix with the base directory, replace namespace
    // separators with directory separators in the relative class name, append
    // with .php
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';

    // if the file exists, require it
    if (file_exists($file)) {
        require $file;
    }
    return true;
}
function __psr4Bootstrap_dhcache($class) {
    $prefix = 'boru\\dhcache\\';

    // base directory for the namespace prefix
    $base_dir = __DIR__ . '/../../vendor/boru/dhcache/src/';

    // does the class use the namespace prefix?
    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        // no, move to the next registered autoloader
        return;
    }

    // get the relative class name
    $relative_class = substr($class, $len);

    // replace the namespace prefix with the base directory, replace namespace
    // separators with directory separators in the relative class name, append
    // with .php
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';

    // if the file exists, require it
    if (file_exists($file)) {
        require $file;
    }
    return true;
}