<?php
namespace boru\dhutils\multithread;

class MTCallback implements MTCallbackInterface {

    /**
     * @var callable|null
     */
    protected $threadStartCallback;
    /**
     * @var callable|null
     */
    protected $threadFinishedCallback;
    /**
     * @var callable|null
     */
    protected $collectCallback;
    /**
     * @var callable|null
     */
    protected $loopCallback;

    /**
     * Internal variable to calculate self::timeSinceLastLoop()
     * @var float
     */
    protected $lastLoopTime = 0;
    /**
     * Internal variable to calculate self::timeSinceLastLoop()
     * @var float
     */
    protected $loopTime = 0;

    /**
     * @param \boru\dhutils\dhThreads $pool the threadpool, so more work can be added if needed
     * @param \boru\dhutils\dhThreads\multithread\Thread $thread 
     * @return void 
     */
    public function threadStart($pool,$thread) {
        if(is_callable($this->threadStartCallback)) {
            $cb = $this->threadStartCallback;
            $cb($pool,$thread);
        }
    }

    /**
     * @param \boru\dhutils\dhThreads $pool the threadpool, so more work can be added if needed
     * @param \boru\dhutils\dhThreads\multithread\Thread $thread 
     * @return void 
     */
    public function threadFinished($pool,$thread) {
        if(is_callable($this->threadFinishedCallback)) {
            $cb = $this->threadFinishedCallback;
            $cb($pool,$thread);
        }
    }
    /**
     * @param \boru\dhutils\dhThreads $pool
     * @return void 
     */
    public function loop($pool) {
        $this->lastLoopTime = $this->loopTime;
        $this->loopTime = microtime(true);
        if(is_callable($this->loopCallback)) {
            $cb = $this->loopCallback;
            $cb($pool);
        }
    }

    /**
     * @param mixed $data
     * @return void 
     */
    public function collect($data) {
        if(is_callable($this->collectCallback)) {
            $cb = $this->collectCallback;
            $cb($data);
        }
    }

    /**
     * Get the value of threadStartCallback
     *
     * @return  callable|null
     */
    public function getThreadStartCallback() {
        return $this->threadStartCallback;
    }

    /**
     * Set the value of threadStartCallback
     *
     * @param   callable  $threadStartCallback  
     * @return  self
     */
    public function setThreadStartCallback(callable $threadStartCallback) {
        $this->threadStartCallback = $threadStartCallback;
        return $this;
    }

    /**
     * Get the value of threadFinishedCallback
     *
     * @return  callable
     */
    public function getThreadFinishedCallback() {
        return $this->threadFinishedCallback;
    }

    /**
     * Set the value of threadFinishedCallback
     *
     * @param   callable  $threadFinishedCallback  
     * @return  self
     */
    public function setThreadFinishedCallback(callable $threadFinishedCallback) {
        $this->threadFinishedCallback = $threadFinishedCallback;
        return $this;
    }

    /**
     * Get the value of throttleWaitCallback
     *
     * @return  callable|null
     */
    public function getThrottleWaitCallback() {
        return $this->loopCallback;
    }

    /**
     * Set the value of throttleWaitCallback
     *
     * @param   callable  $throttleWaitCallback  
     * @return  self
     */
    public function setThrottleWaitCallback(callable $throttleWaitCallback) {
        $this->loopCallback = $throttleWaitCallback;
        return $this;
    }

    /**
     * Get the value of throttleWaitCallback
     *
     * @return  callable|null
     */
    public function getCollectCallback() {
        return $this->collectCallback;
    }

    /**
     * Set the value of throttleWaitCallback
     *
     * @param   callable  $throttleWaitCallback  
     * @return  self
     */
    public function setCollectCallback(callable $collectCallback) {
        $this->collectCallback = $collectCallback;
        return $this;
    }

    /**
     * Get the value of loopCallback
     *
     * @return  callable|null
     */
    public function getLoopCallback() {
        return $this->loopCallback;
    }

    /**
     * Set the value of loopCallback
     *
     * @param   callable  $collectCallback  
     * @return  self
     */
    public function setLoopCallback(callable $loopCallback) {
        $this->loopCallback = $loopCallback;
        return $this;
    }


    /**
     * Returns the microtime float difference between the last loop and this loop
     * @return float
     */
    public function timeSinceLastLoop() {
        return $this->loopTime - $this->lastLoopTime;
    }
}