<?php
namespace boru\dhutils\multithread;

interface MTCallbackInterface {
    /**
     * @param \boru\dhutils\dhThreads $pool the threadpool, so more work can be added if needed
     * @param \boru\dhutils\dhThreads\multithread\Thread $thread 
     * @return void 
     */
    public function threadStart($pool,$thread);

    /**
     * @param \boru\dhutils\dhThreads $pool the threadpool, so more work can be added if needed
     * @param \boru\dhutils\dhThreads\multithread\Thread $thread 
     * @return void 
     */
    public function threadFinished($pool,$thread);

    /**
     * @param \boru\dhutils\dhThreads $pool
     * @return void 
     */
    public function loop($pool);

    /**
     * @param mixed $data
     * @return void 
     */
    public function collect($data);

    /**
     * Get the value of threadStartCallback
     *
     * @return  callable|null
     */
    public function getThreadStartCallback();

    /**
     * Set the value of threadStartCallback
     *
     * @param   callable  $threadStartCallback  
     * @return  self
     */
    public function setThreadStartCallback(callable $threadStartCallback);

    /**
     * Get the value of threadFinishedCallback
     *
     * @return  callable
     */
    public function getThreadFinishedCallback();

    /**
     * Set the value of threadFinishedCallback
     *
     * @param   callable  $threadFinishedCallback  
     * @return  self
     */
    public function setThreadFinishedCallback(callable $threadFinishedCallback);

    /**
     * Get the value of throttleWaitCallback
     *
     * @return  callable|null
     */
    public function getThrottleWaitCallback();

    /**
     * Set the value of throttleWaitCallback
     *
     * @param   callable  $throttleWaitCallback  
     * @return  self
     */
    public function setThrottleWaitCallback(callable $throttleWaitCallback);


    /**
     * Get the value of loopCallback
     *
     * @return  callable|null
     */
    public function getLoopCallback();

    /**
     * Set the value of loopCallback
     *
     * @param   callable  $collectCallback  
     * @return  self
     */
    public function setLoopCallback(callable $loopCallback);
}