<?php
namespace boru\dhutils\multithread;

use \boru\dhutils\dhGlobal;
use \boru\dhutils\dhThreads;

dhGlobal::logger("debugger",dhGlobal::LOG_ALL,true,false);
class Runner {
    
    protected $id;
    protected $command;
    protected $return = false;
    protected $channel;
    protected $channelType = dhThreads::CHANNEL_NONE;

    protected $debugMode;

    /**
     * Expects a dhThreads packed arg that contains:
     * id -- string - id used for communication
     * command -- the command to execute, including any command line arguments
     * return -- true/false -- wether or not to return output
     * channelType -- string -- defaults to dhThreads::CHANNEL_NONE
     */
    public static function init($args) {
        $data = dhThreads::unpack($args);
        return new self($data);
    }

    public function __construct($data=[]) {
        $this->id = dhGlobal::getVal($data,"id",false);
        $this->command = dhGlobal::getVal($data,"command",false);
        $this->return = dhGlobal::getVal($data,"return",false);
        $this->channelType = dhGlobal::getVal($data,"channelType",dhThreads::CHANNEL_NONE);
        $this->bootstrap = dhGlobal::getVal($data,"bootstrap",false);
        if((dhGlobal::getVal($data,"debug",false)) !== false) {
            $this->debugMode = true;
        } elseif((dhGlobal::getVal($data,"debugMode",false)) !== false) {
            $this->debugMode = true;
        }
        if($this->bootstrap !== false && file_exists($this->bootstrap)) {
            include $this->bootstrap;
        }
        dhThreads::sendChannel($this->id,$this->channelType,$this->run());
    }
    public function run() {
        $this->debug($this->command);
        ob_start();
        passthru($this->command);
        $data = ob_get_contents();
        ob_end_clean();
        return $data;
    }

    public function debug(...$data) {
        if($this->debugMode) {
            array_unshift($data,"[T- exec]  ");
            dhGlobal::debug(...$data);
        }
    }
}