<?php
namespace boru\dhutils\multithread\parts;

class Buffer {
    protected $out = [];
    protected $err = [];
    protected $closed = false;

    public function __construct() {

    }
    public function out($data=null) {
        if($this->closed) {
            return false;
        }
        $this->out = array_merge($this->out,explode("\n",$data));
        return $this;
    }
    public function err($data=null) {
        if($this->closed) {
            return false;
        }
        $this->err = array_merge($this->out,explode("\n",$data));
        return $this;
    }
    public function close() {
        $this->closed;
    }

    /**
     * Read the stdOut and stdErr buffers and optionally consumes them ($consume=true by default)
     * 
     * @param bool $asArray (default:true) if true, retrieve an array of lines. Else, lines will be glued together with \n
     * @param bool $consume (default:true) if true, resets the Out and Err buffers to empty
     * @return (bool|array)[] 
     */
    public function read($asArray=true,$consume=true) {
        $out = $this->readOut($asArray,$consume);
        $err = $this->readErr($asArray,$consume);
        $closed = $this->closed;
        return ["closed"=>$closed,"out"=>$out,"err"=>$err];
    }

    /**
     * Read the stdOut buffer and optionally consume it ($consume=true by default)
     * 
     * @param bool $asArray (default:true) if true, retrieve an array of lines. Else, lines will be glued together with \n
     * @param bool $consume (default:true) if true, resets the Out buffer to empty
     * @return array 
     */
    public function readOut($asArray=true,$consume=true) {
        $out = $this->out;
        if($consume) {
            $this->out = [];
        }
        return $asArray ? $out : implode("\n",$out);
    }

    /**
     * Read the stdErr buffer and optionally consume it ($consume=true by default)
     * 
     * @param bool $asArray (default:true) if true, retrieve an array of lines. Else, lines will be glued together with \n
     * @param bool $consume (default:true) if true, resets the Err buffer to empty
     * @return array 
     */
    public function readErr($asArray=true,$consume=true) {
        $err = $this->err;
        if($consume) {
            $this->err = [];
        }
        return $asArray ? $err : implode("\n",$err);
    }

    /**
     * Returns an array of 'closed' (bool), 'out' (array), 'err' (array) without consuming the data (leaves it in tact)
     * 
     * @return (bool|array)[] 
     */
    public function get() {
        return ["closed"=>$this->closed,"out"=>$this->out,"err"=>$this->err];
    }
}