<?php
namespace boru\dhutils\tools;

use boru\dhutils\dhGlobal;
use boru\dhutils\filesys\File;

class JSONL {
    private $lines = [];
    private $lineCount = 0;

    private static $filesCache = [];

    /**
     * @var File
     */
    private $file;

    public function __construct($options=[]) {
        $this->lines = dhGlobal::getVal($options,"lines",[]);
        $this->lineCount = dhGlobal::getVal($options,"lineCount",0);
        if(($file = dhGlobal::getVal($options,"file",null))!==null) {
            $this->setFile($file);
        }
    }
    public function setFile($file,$load=true) {
        if(is_object($file) && $file instanceof File) {
            $this->file = $file;
            if($load) {
                $this->loadString($file->content());
            }
        } elseif(is_string($file)) {
            $this->file = File::from($file);
            if($load) {
                $this->loadString($this->file->content());
            }
        } else {
            throw new \Exception("Invalid file type");
        }
    }
    public function addLine($line,$save=false) {
        $this->lines[] = $line;
        $this->lineCount++;
        if($save && is_object($this->file) && $this->file instanceof File) {
            $this->file->content($this->__toString());
        }
    }
    public function append($line) {
        if(is_object($this->file) && $this->file instanceof File) {
            $string = "";
            if($this->lineCount>=1) {
                $string = "\n";
            }
            $string.= static::encodeLine($line);
            $this->file->write($string,true);
            echo "written\n";
            return true;
        } else {
            $this->addLine($line);
            return false;
        }
    }
    public function getLines() {
        return $this->lines;
    }
    public function getLineCount() {
        return $this->lineCount;
    }
    
    public function loadString($string) {
        $data = explode("\n",$string);
        foreach($data as $line) {
            $this->lines[] = json_decode($line,true);
        }
        $this->lineCount = count($this->lines);
        return $this;
    }

    public function toString() {
        return $this->__toString();
    }
    public function __toString() {
        $lines = [];
        foreach($this->lines as $line) {
            $enc = static::encodeLine($line);
            if(!empty($enc)) {
                $lines[] = $enc;
            }
        }
        return implode("\n",$lines);
    }
    /**
     * @param string|File $filename
     * @return File
     */
    public function toFile($filename) {
        if(is_object($filename) && $filename instanceof File) {
            $filename->write($this->__toString());
            $this->file = $filename;
            return $filename;
        } else {
            $file = File::from($filename);
            $file->write($this->__toString());
            $this->file = $file;
            return $file;
        }
    }

    public static function encodeLine($data) {
        return json_encode($data,JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
    }

    public static function appendFile($file,$line) {
        if(!is_object($file) && !($file instanceof File)) {
            $file = File::from($file);
        }
        if(is_object($file) && $file instanceof File) {
            if(!isset(self::$filesCache[$file->path()])) {
                self::$filesCache[$file->path()] = $file->size();
            } else {
                clearstatcache();
            }
            $string = "";
            if(self::$filesCache[$file->path()]>0) {
                $string = "\n";
            } else {
                self::$filesCache[$file->path()]++;
            }
            
            $string.= static::encodeLine($line);
            $file->write($string,true);
            return true;
        } else {
            return false;
        }
    }


    public static function fromFile($filename) {
        if(is_object($filename) && $filename instanceof File) {
            return new JSONL(["file"=>$filename]);
        } else {
            $file = File::from($filename);
            return new JSONL(["file"=>$filename]);
        }
    }
    public static function fromString($string) {
        $jsonl = new JSONL();
        $jsonl->loadString($string);
        return $jsonl;
    }
}