<?php
namespace boru\dhutils\tools;

use boru\dhutils\filesys\File;

class Output extends \boru\output\Output {

    /**
     * Used to init the singleton with specific settings
     * @return dhOut singlton
     */
    public static function init($stdOut=true,$fileName=false,$prefix=true,$prefixFormat="date:Y-m-d H:i:s",$prefixSpacer="\t",$lineSeparator=PHP_EOL) {
        $options = [
            "stdOut"=>$stdOut,
            "fileName"=>$fileName,
            "prefix"=>$prefix,
            "prefixFormat"=>$prefixFormat,
            "prefixSpacer"=>$prefixSpacer,
            "lineSeparator"=>$lineSeparator,
        ];
        return parent::init($options);
    }

    public function __construct($stdOut=true,$fileName=false,$prefix=true,$prefixFormat="date:Y-m-d H:i:s",$prefixSpacer="\t",$lineSeparator=PHP_EOL) {
        $options = [
            "stdOut"=>$stdOut,
            "fileName"=>$fileName,
            "prefix"=>$prefix,
            "prefixFormat"=>$prefixFormat,
            "prefixSpacer"=>$prefixSpacer,
            "lineSeparator"=>$lineSeparator,
        ];
        parent::__construct($options);
    }
    public function __destruct() {
        if(!empty($this->output)) {
            $this->end();
        }
    }

    public function clear() {
        $this->end();
    }

    /**
     * Set the value of prefix
     *
     * @return  self
     */ 
    public function setPrefix($prefix)
    {
        $this->prefix($prefix);

        return $this;
    }

    /**
     * Set the value of prefixFormat
     *
     * @return  self
     */ 
    public function setPrefixFormat($prefixFormat)
    {
        $this->prefixFormat($prefixFormat);

        return $this;
    }

    /**
     * Set the value of trailingNewLine
     *
     * @return  self
     */ 
    public function setTrailingNewLine($trailingNewLine)
    {
        $this->trailingNewLine($trailingNewLine);

        return $this;
    }

    /**
     * Set the value of fileName
     *
     * @return  self
     */ 
    public function setFileName($fileName)
    {
        $this->fileName($fileName);
        return $this;
    }

    /**
     * Set the value of stdOut
     *
     * @return  self
     */ 
    public function setStdOut($stdOut)
    {
        $this->stdOut($stdOut);

        return $this;
    }

    /**
     * Set the value of prefixSpacer
     *
     * @return  self
     */ 
    public function setPrefixSpacer($prefixSpacer)
    {
        $this->prefixSpacer($prefixSpacer);
        return $this;
    }

    /**
     * Set the value of fileAppend
     *
     * @return  self
     */ 
    public function setFileAppend($fileAppend)
    {
        $this->fileAppend($fileAppend);
        return $this;
    }

    /**
     * Get the value of indent
     */ 
    public function getIndent()
    {
        return $this->option("indent");
    }

    /**
     * Set the value of indent
     *
     * @return  self
     */ 
    public function setIndent($indent)
    {
        $this->option("indent",$indent);
        return $this;
    }

    /**
     * Get the value of lineSeparator
     *
     * @return  mixed
     */
    public function getLineSeparator() {
        return $this->lineSeparator();
    }

    /**
     * Set the value of lineSeparator
     *
     * @param   mixed  $lineSeparator  
     * @return  self
     */
    public function setLineSeparator($lineSeparator) {
        $this->lineSeparator($lineSeparator);
        return $this;
    }


}