<?php
namespace boru\dhutils\tools;

class ScriptLock {
    public $lockPath = "/tmp/";
    public $lockFile;
    public function __construct($lockFile,$lockPath="/tmp/") {
        $this->lockPath = $lockPath;
        $this->lockFile = $lockFile;
    }
    public function __destruct() {
        if(file_exists($this->lockFile())) {
            unlink($this->lockFile());
        }
    }

    public function lockFile() {
        if(substr($this->lockPath,-strlen(DIRECTORY_SEPARATOR)) !== DIRECTORY_SEPARATOR) {
            $this->lockPath.=DIRECTORY_SEPARATOR;
        }
        return $this->lockPath.$this->lockFile;
    }

    public function isLocked() {
        # If lock file exists, check if stale.  If exists and is not stale, return TRUE
        # Else, create lock file and return FALSE.

        if (file_exists($this->lockFile())) {
            # check if it's stale
            $lockingPID = trim(file_get_contents($this->lockFile()));

            # Get all active PIDs.
            $pids = explode("\n", trim(`ps -e | awk '{print $1}'`));

            # If PID is still active, return true
            if (in_array($lockingPID, $pids)) return true;

            # Lock-file is stale, so kill it.  Then move on to re-creating it.
            unlink($this->lockFile());
        }

        file_put_contents($this->lockFile(), getmypid() . "\n");
        return false;

    }
}