<?php
namespace boru\dhutils\tools;

use boru\dhutils\dhGlobal;
use boru\dhutils\tools\StdOut;

class Template {
    private $functionParser = '/({([a-zA-Z0-9]+)\|?([a-zA-Z0-9:]*)\|?([a-zA-Z0-9:]*)\|?([a-zA-Z0-9:]*)})/';
    private $customMethods = [];
    private $customModifiers = [];


    public function registerMethod($methodName,callable $callable) {
        $this->customMethods[$methodName] = $callable;
    }
    public function registerModifier($modifierName,callable $callable) {
        $this->customModifiers[$modifierName] = $callable;
    }
    public function parse($content,$data=[]) {
        return preg_replace_callback($this->functionParser,function($matches) use ($data) {
            return $this->variableCallback($matches,$data);
        },$content);
    }
    private function variableCallback($matches,$dataArray=[]) {
        array_shift($matches);
        array_shift($matches);
        $variable = !empty($matches) ? array_shift($matches) : false;
        $modifiers = [];
        while(!empty($matches)) {
            $mod = array_shift($matches);
            if(!empty($mod)) {
                $modifiers[] = $mod;
            }
        }

        $value = "";
        if($variable !== false && !empty($variable)) {
            
            if(isset($dataArray[$variable]) && !is_array($dataArray[$variable])) {
                $value = $dataArray[$variable];
            } elseif(isset($dataArray[$variable]) && is_array($dataArray[$variable])) {
                if(isset($dataArray[$variable."Template"])) {
                    $tpl = $dataArray[$variable."Template"];
                    $valueArr = [];
                    foreach($dataArray[$variable] as $vars) {
                        $valueArr[] = preg_replace_callback($this->functionParser,function($matches) use ($vars) {
                            return $this->variableCallback($matches,$vars);
                        },$tpl);
                    }
                    $value = implode(" ",$valueArr);
                }
            } elseif(isset($this->customMethods[$variable]) && is_callable($this->customMethods[$variable])) {
                $value = $this->customMethods[$variable]($this,$dataArray);
            }

        }
        if(!empty($modifiers)) {
            foreach($modifiers as $modifier) {
                /*if($modifier == "timeFormat") {
                    $value = $this->formatTime($value);
                } elseif($modifier == "since") {
                    if(is_null($value) || empty($value)) {
                        $value = 0;
                    } else {
                        $value = microtime(true)-$value;
                    }
                } elseif(strstr($modifier,":") !== false) {
                    $value = $this->parseFunction($modifier,$value);
                } elseif(isset($this->customModifiers[$modifier]) && is_callable($this->customModifiers[$modifier])) {
                    $value = $this->customModifiers[$modifier]($this,$value);
                }*/
                $value = $this->parseModifier($modifier,$value);
            }
        }
        return $value;
    }

    private function parseModifier($modifierString,$value) {
        $found = false;
        if(strstr($modifierString,":") !== false) {
            $arr = explode(":",$modifierString);
            $modifier = array_shift($arr);
            $args = $arr;
        } else {
            $modifier = $modifierString;
            $args = [];
        }
        $callable = ["\\boru\\dhutils\\templates\\modifiers\\".$modifier,$modifier];
        if(is_callable($callable)) {
            return call_user_func($callable,$value,...$args);
        } elseif(isset($this->customModifiers[$modifier]) && is_callable($this->customModifiers[$modifier])) {
            return $this->customModifiers[$modifier]($this,$value,...$args);
        }
    }

    private function parseFunction($modifier,$value) {
        $arr = explode(":",$modifier);
        $func = array_shift($arr);
        if($func == "pad") {
            $len   = static::shiftArray($arr,     1);
            $style = static::shiftArray($arr,"left");
            if($style == "right") {
                $value = dhGlobal::padRight($value,$len," ");
            } elseif($style == "mid") {
                $value = dhGlobal::padMid($value,$len," ");
            } else {
                $value = dhGlobal::padLeft($value,$len," ");
            }
        } elseif($func == "max") {
            $len   = static::shiftArray($arr, 10);
            $value = substr($value,0,$len);
        }
        return $value;
    }
    public function formatTime($time) {
        if(!is_numeric($time)) {
            return $time;
        }
        if($time<=60) {
            $str = sprintf("%01.2f",$time)."s";
        } else {
            $time = round($time);
            $dtF = new \DateTime('@0');
            $dtT = new \DateTime("@$time");
            
            $str = dhGlobal::dateIntervalToElapsed($dtF->diff($dtT),true,false,2,"");
        }
        return $str;
    }
    public static function shiftArray(&$array,$default=null) {
        return !empty($array) ? array_shift($array) : $default;
    }
}