<?php
namespace boru\dhutils\tools;

class Time {
    /** @var int */
    private $timestamp;
    /** @var \DateTime */
    private $dateTime;

    public function __construct($input=null) {
        if(!is_null($input)) {
            $this->setInput($input);
        } else {
            $this->dateTime = new \DateTime();
            $this->timestamp = $this->dateTime->getTimestamp();
        }
    }

    public function setInput($input) {
        if(is_numeric($input)) {
            $this->setTimestamp($input);
        } elseif(is_object($input) && $input instanceof \DateTime) {
            $this->setDateTime($input);
        } elseif(is_string($input)) {
            $this->setDateTime($input);
        }
        return $this;
    } 

    public function setTimestamp($timestamp) {
        if(is_numeric($timestamp)) {
            $this->timestamp = $timestamp;
            $this->dateTime = new \DateTime();
            $this->dateTime->setTimestamp($timestamp);
        }
        return $this;
    }
    public function setDateTime($dateTime) {
        if(is_object($dateTime) && $dateTime instanceof \DateTime) {
            $this->dateTime = $dateTime;
            $this->timestamp = $dateTime->getTimestamp();
        } elseif(is_string($dateTime)) {
            try {
                $this->dateTime = new \DateTime($dateTime);
                $this->timestamp = $this->dateTime->getTimestamp();
            } catch(\Exception $e) {
                $this->dateTime = null;
                $this->timestamp = null;
            }
        }
        return $this;
    }

    public function timestamp() {
        return $this->timestamp;
    }
    public function ts() {
        return $this->timestamp;
    }
    public function dateTime() {
        return $this->dateTime;
    }
    public function dt() {
        return $this->dateTime;
    }
    public function format($format="Y-m-d H:i:s",$timeZone=null) {
        if(!is_null($timeZone)) {
            $dt = clone $this->dateTime;
            if(is_string($timeZone)) {
                $timeZone = new \DateTimeZone($timeZone);
            } elseif(!is_object($timeZone) || !$timeZone instanceof \DateTimeZone) {
                $timeZone = new \DateTimeZone(date_default_timezone_get());
            }
            $dt->setTimezone($timeZone);
            return $dt->format($format);
        }
        return $this->dateTime->format($format);
    }

    public static function create($input=null) {
        return new self($input);
    }
    public static function now() {
        return new self();
    }
}