<?php
namespace boru\dhutils\traits;

use boru\dot\Dot;

trait ContainerTrait {
    public function fromArray($data) {
        if(!is_array($data)) {
            //try to json decode the data
            $data = json_decode($data,true);
            if(!$data) {
                throw new \Exception("Data must be an array or a valid JSON string");
            }
        }
        foreach($data as $key => $value) {
            $this->set($key, $value);
        }
    }

    

    /**
     * Convert the container to an array
     * @return array 
     */
    public function toArray() {
        return $this->data;
    }

    /**
     * Get a value from the container using dot notation
     * @param mixed $key 
     * @param mixed $default 
     * @return mixed 
     */
    public function dotGet($key,$default=null) {
        return Dot::get($this->data,$key,$default);
    }

    /**
     * Set a value in the container using dot notation
     * @param mixed $key 
     * @param mixed $value 
     * @return Container 
     */
    public function dotSet($key,$value) {
        Dot::set($this->data,$key,$value);
        return $this;
    }

    /**
     * Get a value from the container
     * @param mixed $key 
     * @return Container 
     */
    public function get($name=null,$default=null) {
        if($name === null) {
            return $this->data;
        }
        if(array_key_exists($name, $this->data)) {
            return $this->data[$name];
        }
        $snakeCase = strtolower(preg_replace('/(?<!^)[A-Z]/', '_$0', $name));
        if(array_key_exists($snakeCase, $this->data)) {
            return $this->data[$snakeCase];
        }
        $camelCase = lcfirst(str_replace(' ', '', ucwords(str_replace('_', ' ', $name))));
        if(array_key_exists($camelCase, $this->data)) {
            return $this->data[$camelCase];
        }
        return $this->dotGet($name,$default);
    }

    /**
     * Set a value in the container
     * @param mixed $name 
     * @param mixed $value 
     * @return $this|Container 
     */
    public function set($name,$value) {
        if(array_key_exists($name, $this->data)) {
            $this->data[$name] = $value;
            return $this;
        }
        $snakeCase = strtolower(preg_replace('/(?<!^)[A-Z]/', '_$0', $name));
        if(array_key_exists($snakeCase, $this->data)) {
            $this->data[$snakeCase] = $value;
            return $this;
        }
        $camelCase = lcfirst(str_replace(' ', '', ucwords(str_replace('_', ' ', $name))));
        if(array_key_exists($camelCase, $this->data)) {
            $this->data[$camelCase] = $value;
            return $this;
        }
        return $this->dotSet($name,$value);
    }
}