<?php
namespace boru\dhutils\traits;

trait GlobalDotParse {
    /**
     * Get an element from $arr based on dot notation
     * 
     * Example:
     * 
     * dhGlobal::getDot(['key'=>['subkey'=>'value']],'key.subkey') -- returns 'value'
     * 
     * @param array $arr the array to get the element from
     * @param string $dotString the key to find
     * @param mixed $default a default value if key isn't found
     * @return mixed the value if found, $defualt if not
     */
    public static function getDot($arr=[],$dotString,$default=null,$separator=".") {
		$pieces = explode($separator,$dotString);
		$pointer = $arr;
		for($i=0;$i<count($pieces);$i++) {
			if(isset($pointer[$pieces[$i]])) {
				$pointer = $pointer[$pieces[$i]];
			} else {
				return $default;
			}
		}
		return $pointer;
	}
    /**
     * Alias function for dhGlobal::getDot()
     */
    public static function getArray($arr=[],$keyString,$default=null,$keySeparator=".") {
        return static::getDot($arr,$keyString,$default,$keySeparator);
    }
    /**
     * Alias function for dhGlobal::getDot()
     */
    public static function getVal($arr=[],$keyString,$default=null,$keySeparator=".") {
        return static::getDot($arr,$keyString,$default,$keySeparator);
    }
    /**
     * Alias function for dhGlobal::getDot()
     */
    public static function dotGet($arr=[],$keyString,$default=null,$keySeparator=".") {
        return static::getDot($arr,$keyString,$default,$keySeparator);
    }

    /**
     * getDot multiple.. accepts an array of parameters to search
     * 
     * returns an array of all found values for matching parameters..
     * 
     * @param array $arr array to search
     * @param array $keyDefault array of key=>defaults
     * @param string $keySeparator (default='.') string to split for 'dot search'
     * @param boolean $single (default=false) if true, returns the first matching value in order of $keyDefault key definitions
     * @return mixed if $single==false array of values for each of the keyDefault pairs. Otherwise the first matching value
     */
    public static function getMultiVal(array $arr,array $keyValueArray,$single=false,$keySeparator=".") {
        $values = [];
        foreach($keyValueArray as $keyString=>$default) {
            $value = static::getVal($arr,$keyString,$default,$keySeparator);
            if($single && $value!==$default) {
                return $value;
            }
            $values[] = $value;
        }
        return $values;
    }

    public static function parseDots(&$array,$separator='.') {
		foreach($array as $k=>$v) {
			if(is_array($v)) {
				$array[$k] = static::parseDots($v,$separator);
			}
			if(strpos($k,$separator) !== false) {
				static::dotAssign($array,$k,$v,$separator);
				unset($array[$k]);
			}
		}
	}
    /**
     * Explodes dot notation and assigns a value based on the key
     * 
     * Example:
     * 
     * $arr = ['key'=>['subkey'=>'value']];
     * 
     * dhGlobal::dotAssign($arr,'key.subkey2','value2)
     * 
     * //['key'=>['subkey'=>'value','subkey2'=>'value2']]
     * 
     * @param array $arr the array to get the element from
     * @param string $path the dotNotated key
     * @param mixed $value the value to assign
     * @param string $separator defaults to '.'
     * @return void
     */
	public static function dotAssign(&$arr, $path, $value=null, $separator='.') {
		$keys = explode($separator, $path);

		foreach ($keys as $key) {
			$arr = &$arr[$key];
		}

		$arr = $value;
	}
    public static function dotDelete(&$arr, $path, $separator='.') {
		$keys = explode($separator, $path);
        $end = array_pop($keys);
		foreach ($keys as $key) {
			$arr = &$arr[$key];
            
		}
        unset($arr[$end]);
	}

    /**
     * Flatten a multi-dimensional associative array to dot notation
     * @param mixed $array 
     * @param string $prepend 
     * @return array 
     */
    public static function arrayDot($array, $prepend = '') {
        $results = [];

        foreach ($array as $key => $value) {
            if (is_array($value) && ! empty($value)) {
                $results = array_merge($results, static::arrayDot($value, $prepend.$key.'.'));
            } else {
                $results[$prepend.$key] = $value;
            }
        }

        return $results;
    }
}