<?php
namespace boru\dhutils\traits;

trait IteratorTrait {
    public function current() {
        $this->assertIterator();
        return current($this->data);
    }
    public function key() {
        $this->assertIterator();
        return key($this->data);
    }
    public function next() {
        $this->assertIterator();
        return next($this->data);
    }
    public function rewind() {
        $this->assertIterator();
        return reset($this->data);
    }
    public function valid() {
        $this->assertIterator();
        return key($this->data) !== null;
    }

    public function add($value) {
        $this->assertIterator();
        $this->data[] = $value;
        return $this;
    }
    public function remove($value) {
        $this->assertIterator();
        $key = array_search($value, $this->data);
        if($key !== false) {
            unset($this->data[$key]);
        }
        return $this;
    }
    public function clear() {
        $this->data = [];
        return $this;
    }
    public function removeKey($key) {
        $this->assertIterator();
        if(isset($this->data[$key])) {
            unset($this->data[$key]);
        }
        return $this;
    }
    public function shift() {
        $this->assertIterator();
        return array_shift($this->data);
    }
    public function pop() {
        $this->assertIterator();
        return array_pop($this->data);
    }
    public function unshift($value) {
        $this->assertIterator();
        array_unshift($this->data, $value);
        return $this;
    }

    private function assertIterator() {
        if(!is_array($this->data)) {
            throw new \Exception("Data must be an array");
        }
    }
}