<?php
namespace boru\dhutils\traits;

use boru\dhutils\dhGlobal;
use boru\dhutils\ReflectionNamespace;
use \ReflectionClass;

trait Reflection {

    /**
     * Get all class names from a namespace
     * @param string $namespace
     * @return string[]
     */
    public static function getClassNames($namespace) {
        $reflection = self::namespaceReflection($namespace);
        return $reflection->getClassNames();
    }

    /**
     * Get all classes from a namespace
     * @param string $namespace
     * @return ReflectionClass[]
     */
    public static function getClasses($namespace) {
        $reflection = self::namespaceReflection($namespace);
        return $reflection->getClasses();
    }

    /**
     * Get all namespace names from a namespace
     * @param string $namespace
     * @return string[]
     */
    public static function getNamespaceNames($namespace) {
        $reflection = self::namespaceReflection($namespace);
        return $reflection->getNamespaceNames();
    }

    /**
     * Get all namespaces from a namespace
     * @param string $namespace
     * @return ReflectionNamespace[]
     */
    public static function getNamespaces($namespace) {
        $reflection = self::namespaceReflection($namespace);
        return $reflection->getNamespaces();
    }

    /**
     * Get a class from a namespace
     * @param string $namespace
     * @param string $class
     * @return ReflectionClass
     */
    public static function getClass($namespace,$class) {
        $reflection = self::namespaceReflection($namespace);
        return $reflection->getClass($class);
    }

    /**
     * Check if the namespace has a parent namespace
     * @param string $namespace
     * @param string $name
     * @return bool
     */
    public static function hasNamespace($namespace,$name) {
        $reflection = self::namespaceReflection($namespace);
        return $reflection->hasNamespace($name);
    }

    /**
     * @param string $namespace
     * @return void
     */
    public static function reloadNamespace($namespace) {
        $reflection = self::namespaceReflection($namespace);
        return $reflection->reload();
    }

    /**
     * @param string $namespace
     * @return void
     */
    public static function reloadNamespaces($namespace) {
        $namespaceReflections = dhGlobal::get("namespaceReflections",[]);
        if(isset($namespaceReflections[$namespace])) {
            foreach($namespaceReflections as $namespace=>$reflection) {
                $reflection->reload();
            }
        }
    }

    /**
     * @param string $namespace
     * @return ReflectionNamespace
     */
    public static function namespaceReflection($namespace) {
        $namespaceReflections = dhGlobal::get("namespaceReflections",[]);
        if(isset($namespaceReflections[$namespace])) {
            return $namespaceReflections[$namespace];
        }
        $reflection = new ReflectionNamespace($namespace);
        $namespaceReflections[$namespace] = $reflection;
        dhGlobal::set("namespaceReflections",$namespaceReflections);
        return $reflection;
    }
}