<?php

use boru\dhutils\dAsyncHttp;
use boru\dhutils\dhGlobal;
use React\Promise\Deferred;

class AsyncBootstrapTest {
    public static function setup(...$args) {
        if(empty($args)) {
            return json_encode(["message"=>"setupNoArgs"]);
        }
        return json_encode($args);
    }
    public static function getRand($minSeconds=0,$maxSeconds=2) {
        $minMicro = $minSeconds*1000000;
        $maxMicro = $maxSeconds*1000000;
        $rand = rand($minMicro,$maxMicro);
        $seconds = round($rand / 1000000,2);
        return ["value"=>$rand,"seconds"=>$seconds];
    }
    public static function run($id=0,$minRand=0.5,$maxRand=3) {
        $rand = static::getRand($minRand,$maxRand);
        usleep($rand["value"]);
        $seconds = $rand["seconds"];
        $result = [];
        $result["id"] = $id;
        $result["sleep"] = $seconds;
        return $result;
    }
    public static function testRun(...$args) {
        /*if(empty($args)) {
            return json_encode(["message"=>"emptyArgs"]);
        }
        return json_encode($args);*/
        return file_get_contents(__DIR__."/../bad.txt");
    }
    public static function http(...$args) {
        $deferred = new Deferred();
        $responded=false;
        $client = dAsyncHttp::client(
            [
                "async"=>true,
            ]
        );
        //$client->url("http://localhost/mtest.php?sleepTime=15");
        $client->url("http://localhost/mtest.php");
        $client->post()->done(function(\boru\dhutils\guzzle\Response $response) use (&$deferred,&$responded) {
            if(!$responded) {
                $responded=true;
                $deferred->resolve($response->body());
            }
        });
        return $deferred->promise();
    }
}