# boru/dweb — Framework Overview

`boru/dweb` is a lightweight, explicit PHP web framework designed for
**modular UIs, APIs, and event-driven responses** (JSON, SSE, HTML),
without magic, reflection, or hidden coupling.

This document describes the framework at a conceptual level.

---

## What dweb IS

- A **framework**, not an application
- Explicit, predictable, and inspectable
- Module-first (all endpoints live in modules)
- Dependency-injection driven
- Rendering-agnostic (Smarty is an implementation detail)

---

## What dweb is NOT

- Not Laravel / Symfony
- No autowiring
- No annotations
- No global state
- No implicit controllers
- No framework-owned routes

---

## PHP Compatibility Constraint (LOCKED IN)

The framework must remain compatible with:

- PHP 5.6 (minimum)
- PHP 7.x
- PHP 8.x

Implications:
- No typed properties
- No union types
- No arrow functions
- No constructor property promotion
- No attributes
- No reliance on PHP 7+ stdlib features without fallbacks

All core and extension code must adhere to this constraint unless explicitly stated otherwise.


---

## Core vs Modules (LOCKED IN)

### Core framework responsibilities

- HTTP request / response
- Routing
- Middleware pipeline
- Dependency injection container
- Module lifecycle
- Error handling
- Rendering contracts
- Debug tooling

**Core owns ZERO application endpoints.**

---

### Modules responsibilities

A module is a self-contained feature bundle.

Modules own:

- Views (HTML responses)
- Actions (JSON / SSE / side effects)
- Domain services
- Templates
- Assets
- Integration logic

---

## Terminology (LOCKED IN)

| Term   | Meaning |
|------|--------|
| View | Controller that returns HTML |
| Action | Controller that returns JSON / SSE |
| Module | A feature bundle (routes + services + templates) |

There are **no Pages** in dweb.  
Everything HTML is a **View**.

---

## Namespacing Rules (LOCKED IN)

### Core framework

```

boru\dweb*

```

### Modules

```

boru\dweb\Modules<ModuleName>*

```

Example:
```

boru\dweb\Modules\Skeleton\Views\HomeView
boru\dweb\Modules\Skeleton\Actions\EchoAction

```

---

## Routing Model

Routes are always qualified as:

```

<Module>.<name>

```

### Supported entry points

| URL | Meaning |
|---|---|
| `/Skeleton/home` | View |
| `/api/Skeleton/echo` | Action |
| `/?view=Skeleton.home` | Query fallback |
| `/?action=Skeleton.echo` | Query fallback |

Default module + view are configurable.

---

## Dependency Injection

### Container

- Explicit
- No reflection
- No autowiring

Supported bindings:

```php
$container->set($id, $value);           // shared
$container->set($id, callable);         // shared factory
$container->factory($id, callable);     // non-shared
$container->get($id);
```

---

### Controllers

Controllers:

* Do NOT receive WebConfig
* Do NOT access globals
* Are constructed via factories

Dependencies come from:

* Container
* Constructor injection
* Abstract base classes (Views / Actions)

---

## Settings

All configuration flows through:

```
SettingsInterface
```

Concrete implementation:

```
WebConfig
```

Settings are injected into:

* Module registration
* Container bootstrap
* Services
* Renderers

**Controllers never receive Settings directly.**

---

## Rendering

Rendering is contract-driven.

Core contracts:

* `RendererInterface`
* `TemplateLocatorInterface`

Current implementation:

* Smarty (via a shim)

### Rendering flow

```
View → Renderer → Template → Layout
```

Templates are:

* Module-scoped
* Overridable
* Layout-aware
* Partial/fragment friendly

---

## Error Handling

* All exceptions flow through `ExceptionResponder`
* Content-type aware (HTML vs JSON)
* Debug behavior controlled by settings

Key flags:

* `dweb.debug`
* `dweb.errors.show_trace`
* `dweb.errors.sanitize_*`

---

## Middleware

Middleware is explicit and ordered.

Shipped examples:

* Method override
* JSON body parsing
* Security headers

Middleware runs for:

* Views
* Actions
* Debug endpoints

---

## Debug Tooling

When `dweb.debug = true`:

```
GET /__dweb/routes
```

Returns a JSON dump of all registered views/actions.

This endpoint exists at the router layer and works in:

* WebUI
* CLI smoke tests

---

## Philosophy

dweb favors:

* Explicit wiring over magic
* Predictable structure
* Easy inspection
* Testability
* Long-term maintainability

If something is unclear, the framework is incomplete.
