<?php
use boru\dweb\Support\KernelSpec;
use boru\dweb\Support\KernelBuilder;
use boru\dweb\DwebConfig;
use boru\dweb\Config\ConfigKeys;

$config = DwebConfig::createDefault();
$config->set(ConfigKeys::DEBUG_ENABLED, true);

$spec = KernelSpec::fromConfig($config)
    ->withModules(function ($mm, $c, $cfg) {
        $mm->add(new \boru\dweb\Modules\Skeleton\SkeletonModule());
        // add host modules here
    })
    ->withContainer(function ($c, $cfg) {
        // host service bindings
    })
    ->withMiddleware(null); // CLI usually null

return KernelBuilder::buildEnv($spec);
