<?php
namespace boru\dweb\Cli\Commands;

use boru\dweb\Cli\CommandInterface;
use boru\dweb\Cli\Args;
use boru\dweb\Support\KernelEnv;
use boru\dweb\Config\ConfigKeys;

class PublishCommand implements CommandInterface
{
    /** @var KernelEnv */
    private $env;

    public function __construct(KernelEnv $env = null)
    {
        $this->env = $env;
    }

    public function name() { return 'publish'; }

    public function description()
    {
        return 'Publish module assets (requires --public-assets=/abs/path). Global: --env-bootstrap=..., --setEnv=...';
    }

    public function execute(array $args)
    {
        if (!$this->env) {
            fwrite(STDERR, "ERROR: publish requires env (use --env-bootstrap=...)\n");
            return 2;
        }

        $a = Args::parse($args);

        $public = $a->get('public-assets', null);
        if (!$public || $public === true) {
            fwrite(STDERR, "ERROR: publish requires --public-assets=/absolute/path\n");
            return 2;
        }

        // enforce publish options
        $cfg = $this->env->config();
        $cfg->set(ConfigKeys::ASSET_PUBLISH_ENABLED, true);
        $cfg->set(ConfigKeys::ASSET_PUBLIC_DIR, $public);

        $publisher = $this->env->container()->get(\boru\dweb\Assets\AssetPublisherInterface::class);
        $res = $publisher->publishAll();

        echo "Assets: copied={$res->copied}, skipped={$res->skipped}, errors={$res->errors}\n";
        foreach ($res->messages as $m) echo " - {$m}\n";

        return $res->errors > 0 ? 1 : 0;
    }
}
