<?php
namespace boru\dweb\Contracts;

interface RendererInterface
{
    /**
     * Render a template inside a module scope.
     *
     * @param string $moduleName
     * @param string $templateId  e.g. "dashboard/index"
     * @param array $data
     * @return string
     */
    public function render($moduleName, $templateId, array $data = array());

    /**
     * Render a template into a layout (explicit; no implicit wrapping).
     *
     * Layout receives $content plus any $data variables.
     *
     * @param string $moduleName
     * @param string $layoutId    e.g. "layouts/default"
     * @param string $templateId  e.g. "dashboard/index"
     * @param array $data
     * @return string
     */
    public function renderLayout($moduleName, $layoutId, $templateId, array $data = array());
}
