<?php
namespace boru\dweb;

use boru\dweb\Contracts\AuthProviderInterface;
use boru\dweb\Contracts\ChatServiceInterface;
use boru\dweb\Contracts\TemplateRepositoryInterface;
use boru\dweb\Contracts\ResponseRepositoryInterface;
use boru\dweb\Contracts\HistoryRepositoryInterface;
use boru\dweb\Contracts\ReferenceRepositoryInterface;
use boru\dweb\Contracts\ToolCatalogInterface;
use boru\dweb\Contracts\SettingsInterface;
use boru\dweb\Config\ConfigKeys;

class DwebConfig implements SettingsInterface
{
    /** @var array */
    private $settings = array();

    /**
     * SettingsInterface
     * @param string $key
     * @param mixed $default
     * @return mixed
     */
    public function get($key, $default = null)
    {
        $k = (string)$key;
        return array_key_exists($k, $this->settings) ? $this->settings[$k] : $default;
    }

    /**
     * SettingsInterface
     * @param string $key
     * @param mixed $value
     * @return $this
     */
    public function set($key, $value)
    {
        $this->settings[(string)$key] = $value;
        return $this;
    }

    /**
     * SettingsInterface
     * @return array
     */
    public function all()
    {
        return $this->settings;
    }

    public static function createDefault()
    {
        $c = new self();

        // Infer mount path from URL (e.g. /boruaiweb/index.php => /boruaiweb/)
        $scriptName = isset($_SERVER['SCRIPT_NAME']) ? (string)$_SERVER['SCRIPT_NAME'] : '';
        $mount = '/';
        if ($scriptName !== '') {
            $mount = rtrim(str_replace('\\', '/', dirname($scriptName)), '/');
            if ($mount === '' || $mount === '.') $mount = '/';
            $mount = rtrim($mount, '/') . '/';
        }

        // Host override templates root (optional)
        // Structure: <root>/<Module>/<templateId>.tpl
        $c->set(ConfigKeys::TEMPLATES_PATH, null);

        // Smarty defaults
        $c->set(ConfigKeys::SMARTY_COMPILE_DIR, sys_get_temp_dir() . '/dweb_smarty/compile');
        $c->set(ConfigKeys::SMARTY_CACHE_DIR,   sys_get_temp_dir() . '/dweb_smarty/cache');
        $c->set(ConfigKeys::SMARTY_COMPILE_CHECK, true);
        $c->set(ConfigKeys::SMARTY_CACHING, false);
        $c->set(ConfigKeys::SMARTY_CACHE_LIFETIME, 0);

        // Logging
        $c->set(ConfigKeys::LOGGER_CLASS, null); // host may inject a logger instance

        // Security headers (middleware)
        $c->set(ConfigKeys::SECURITY_HEADERS_ENABLED, true);
        $c->set(ConfigKeys::SECURITY_HEADERS_CONTENT_SECURITY_POLICY, null); // e.g. "default-src 'self'; img-src 'self' data:;"
        // Sane defaults
        $c->set(ConfigKeys::URLS_CANONICAL_ENABLED, true);

        // Debug route dump
        $c->set(ConfigKeys::DEBUG_ROUTES_ENABLED, true);
        $c->set(ConfigKeys::DEBUG_ROUTES_PATH, '/__dweb/routes');

        $c->set(ConfigKeys::ASSET_URL_PREFIX, $mount);   // where $mount ends with '/'
        $c->set(ConfigKeys::ASSET_VERSION, null);        // optional cache busting
        $c->set(ConfigKeys::ASSET_PUBLISH_ENABLED, false);
        $c->set(ConfigKeys::ASSET_PUBLIC_DIR, '');

        return $c;
    }


    public function withAssetUrlPrefix($prefix) { $this->set(ConfigKeys::ASSET_URL_PREFIX, $prefix); return $this; }
    public function withDefaultModule($moduleName) { $this->set(ConfigKeys::DEFAULT_MODULE, $moduleName); return $this; }
    public function withTemplatesPath($path) { $this->set(ConfigKeys::TEMPLATES_PATH, $path); return $this; }
    public function withCanonicalUrls($enabled) { $this->set(ConfigKeys::URLS_CANONICAL_ENABLED, (bool)$enabled); return $this; }
    /**
     * Optional helper if you want to set many at once.
     * @param array $settings
     * @return $this
     */
    public function withSettings(array $settings)
    {
        foreach ($settings as $k => $v) {
            $this->settings[(string)$k] = $v;
        }
        return $this;
    }
}
