<?php
namespace boru\dweb\Exceptions;

use boru\dweb\Exceptions\ContextException;

class TemplateNotFound extends ContextException
{
    public function __construct($module, $templateId, $ext, array $searchPaths = array())
    {
        parent::__construct(
            "Template not found: {$module}::{$templateId}.{$ext}",
            array(
                'module' => (string)$module,
                'template' => (string)$templateId,
                'ext' => (string)$ext,
                'search_paths' => $searchPaths,
            )
        );
    }
}
