<?php
namespace boru\dweb\Http;

class Emitter
{
    /**
     * Emit response to the client.
     * @param Response $res
     * @return void
     */
    public static function emit(Response $res)
    {
        // Status line (PHP will set default 200 if not set)
        $status = $res->status();

        // Headers
        $headers = $res->headers();
        if (!headers_sent()) {
            // Set HTTP response code in a version-safe way
            if (function_exists('http_response_code')) {
                @http_response_code($status);
            } else {
                // Fallback: set a Status header (works on many SAPIs)
                @header('Status: ' . $status);
            }

            foreach ($headers as $name => $value) {
                // allow numeric keys like ['Content-Type: x']
                if (is_int($name)) {
                    @header((string)$value, true);
                } else {
                    @header($name . ': ' . $value, true);
                }
            }
        }

        // Body
        if ($res->isStream()) {
            $producer = $res->body();
            if (is_callable($producer)) {
                // Good SSE hygiene
                self::disableOutputBuffering();
                $producer();
                if (function_exists('flush')) { @flush(); }
            }
            return;
        }

        echo (string)$res->body();
    }

    /**
     * Try to disable output buffering for streaming (safe across versions).
     * @return void
     */
    private static function disableOutputBuffering()
    {
        // End all output buffers if possible
        if (function_exists('ob_get_level') && function_exists('ob_end_flush')) {
            while (ob_get_level() > 0) {
                @ob_end_flush();
            }
        }

        // Turn off compression if enabled (helps SSE)
        if (function_exists('ini_set')) {
            @ini_set('zlib.output_compression', '0');
            @ini_set('output_buffering', 'off');
            @ini_set('implicit_flush', '1');
        }

        if (function_exists('ob_implicit_flush')) {
            @ob_implicit_flush(true);
        }
    }
}
