<?php
namespace boru\dweb\Middleware;

use boru\dweb\Contracts\MiddlewareInterface;
use boru\dweb\Contracts\SettingsInterface;
use boru\dweb\Http\Request;

class SecurityHeadersMiddleware implements MiddlewareInterface
{
    /** @var SettingsInterface */
    private $settings;

    public function __construct(SettingsInterface $settings)
    {
        $this->settings = $settings;
    }

    public function handle(Request $req, $next)
    {
        $res = $next($req);

        if (!(bool)$this->settings->get('dweb.security_headers.enabled', true)) {
            return $res;
        }

        // Add-if-missing so modules can override explicitly if needed
        $res = $this->addIfMissing($res, 'X-Content-Type-Options', 'nosniff');
        $res = $this->addIfMissing($res, 'X-Frame-Options', 'SAMEORIGIN');
        $res = $this->addIfMissing($res, 'Referrer-Policy', 'strict-origin-when-cross-origin');

        $csp = $this->settings->get('dweb.security_headers.csp', null);
        if ($csp) {
            $res = $this->addIfMissing($res, 'Content-Security-Policy', (string)$csp);
        }

        return $res;
    }

    private function addIfMissing($res, $key, $value)
    {
        // Works if your Response has header getters/setters; adapt if needed.
        $existing = $res->header($key, null);
        if ($existing !== null && $existing !== '') return $res;

        $res = $res->withHeader($key, $value);
        return $res;
    }
}
