<?php
namespace boru\dweb\Mvc;

use boru\dweb\Http\JsonResponse;

/**
 * Actions are still "API endpoints" by convention,
 * but they can also return HTML fragments/sections when useful (HTMX, etc).
 *
 * Implementation choice:
 * - AbstractAction extends AbstractView to inherit all rendering helpers
 *   (html/layout/fragment/fragmentToSection/sections/hx helpers).
 * - Keeps JSON helpers for the common API case.
 */
abstract class AbstractAction extends AbstractView
{
    /**
     * Convenience JSON response helper.
     *
     * @param array $data
     * @param int $status
     * @param array $headers
     * @return JsonResponse
     */
    protected function json(array $data, $status = 200, array $headers = array())
    {
        return new JsonResponse($data, $status, $headers);
    }

    /**
     * Standard success wrapper.
     *
     * @param mixed $data
     * @param int $status
     * @return JsonResponse
     */
    protected function success($data = array(), $status = 200)
    {
        return new JsonResponse(array('success' => true, 'data' => $data), $status);
    }

    /**
     * Standard error wrapper.
     *
     * @param mixed $message
     * @param int $status
     * @param array $data
     * @return JsonResponse
     */
    protected function error($message, $status = 400, $data = array())
    {
        return new JsonResponse(
            array('success' => false, 'error' => (string)$message, 'data' => $data),
            $status
        );
    }
}
