<?php
namespace boru\dweb\Rendering;

use boru\dweb\Contracts\RendererInterface;
use boru\dweb\Contracts\TemplateLocatorInterface;

class PhpRenderer implements RendererInterface
{
    /** @var TemplateLocatorInterface */
    private $locator;

    /** @var string */
    private $extension = 'php';

    public function __construct(TemplateLocatorInterface $locator)
    {
        $this->locator = $locator;
    }

    public function render($moduleName, $templateId, array $data = array())
    {
        $path = $this->locator->resolve($moduleName, $templateId, $this->extension);
        if (!$path) {
            throw new \boru\dweb\Http\NotFoundException(
                "Template not found: {$moduleName}::{$templateId}.{$this->extension}"
            );
        }

        // Provide helper as $dweb
        $data['dweb'] = new TemplateHelper($this->locator, $moduleName);


        ob_start();
        extract($data, EXTR_SKIP);
        require $path;
        return (string)ob_get_clean();
    }

    public function renderLayout($moduleName, $layoutId, $templateId, array $data = array())
    {
        $content = $this->render($moduleName, $templateId, $data);

        // layout gets $content plus original $data
        $layoutData = $data;
        $layoutData['content'] = $content;

        return $this->render($moduleName, $layoutId, $layoutData);
    }
}
