<?php
namespace boru\dweb\Routing;

use boru\dweb\Contracts\SettingsInterface;
use boru\dweb\Http\Request;

class CanonicalUrl
{
    /** @var SettingsInterface */
    private $settings;

    /** @var Request */
    private $request;

    public function __construct(SettingsInterface $settings, Request $request)
    {
        $this->settings = $settings;
        $this->request  = $request;
    }

    /**
     * @return bool
     */
    public function enabled()
    {
        return (bool)$this->settings->get('dweb.urls.canonical.enabled', false);
    }

    /**
     * Canonical URL for a view route name: "Skeleton.home"
     * @param string $qualified
     * @return string
     */
    public function view($qualified)
    {
        $qualified = (string)$qualified;

        if ($this->enabled()) {
            list($module, $name) = explode('.', $qualified, 2);
            return $this->request->url($module . '/' . $name);
        }
        $viewWord = $this->settings->get('dweb.page_param', 'view');
        return $this->request->url('?' . $viewWord . '=' . $qualified);
    }

    /**
     * Canonical URL for an action route name: "Skeleton.echo"
     * @param string $qualified
     * @return string
     */
    public function action($qualified)
    {
        $qualified = (string)$qualified;

        if ($this->enabled()) {
            list($module, $name) = explode('.', $qualified, 2);
            return $this->request->url('api/' . $module . '/' . $name);
        }
        $actionWord = $this->settings->get('dweb.action_param', 'action');
        return $this->request->url('?' . $actionWord . '=' . $qualified);
    }
    
    /**
     * Convenience: build qualified view name from module + view key.
     *
     * @param string $module e.g. "Skeleton"
     * @param string $viewName e.g. "home"
     * @return string
     */
    public function qualifyView($module, $viewName)
    {
        return (string)$module . '.' . (string)$viewName;
    }

    /**
     * Convenience: build qualified action name from module + action key.
     *
     * @param string $module e.g. "Skeleton"
     * @param string $actionName e.g. "echo"
     * @return string
     */
    public function qualifyAction($module, $actionName)
    {
        return (string)$module . '.' . (string)$actionName;
    }
}
