<?php
namespace boru\dweb\Routing;

use boru\dweb\Kernel\ModuleManager;

class ModuleViewHandler
{
    /** @var string */
    private $module;

    /** @var string */
    private $view;

    /** @var \boru\dweb\Kernel\Container */
    private $container;

    public function __construct($module, $view, $container)
    {
        $this->module = (string)$module;
        $this->view = (string)$view;
        $this->container = $container;
    }

    public function __invoke($req)
    {
        $vf = ModuleManager::getViewFactory($this->module, $this->container);
        return $vf->make($this->view)->handle($req);
    }
}
