<?php
namespace boru\dweb\Routing;

class RouteCollection
{
    /** @var array<string, callable> */
    private $actions = array();

    /** @var array<string, callable> */
    private $views = array();

    public function addAction($name, $handler, $methods=null)
    {
        $name = (string)$name;

        $m = null;
        if ($methods !== null) {
            if (!is_array($methods)) $methods = array($methods);
            $m = array();
            foreach ($methods as $mm) {
                $mm = strtoupper((string)$mm);
                if ($mm !== '') $m[$mm] = true;
            }
        }

        $this->actions[$name] = array(
            'handler' => $handler,
            'methods' => $m, // null means "any"
        );
        return $this;
    }

    public function addView($name, $handler)
    {
        $this->views[(string)$name] = $handler;
        return $this;
    }

    public function getAction($name)
    {
        $name = (string)$name;
        return isset($this->actions[$name]) ? $this->actions[$name] : null;
    }

    public function getView($name)
    {
        $key = (string)$name;
        return isset($this->views[$key]) ? $this->views[$key] : null;
    }

    /**
     * Create a module-scoped facade so modules can register local names
     * while the underlying storage uses fully-qualified keys.
     *
     * @param string $moduleName
     * @return ModuleRouteCollection
     */
    public function forModule($moduleName)
    {
        return new ModuleRouteCollection($this, $moduleName);
    }

    public function allViews()
    {
        return $this->views; // array of name => callable
    }

    public function allActions()
    {
        return $this->actions; // array of name => ['handler'=>callable,'methods'=>array|null]
    }

}
