# 🎉 Fun Layers

Fun layers are **optional capability extensions** built on top of
the stable dweb core.

They do not modify routing, DI, or module contracts.

---

## Implemented Fun Layers

### Fragment Rendering

- Layout-free HTML output
- Explicit rendering
- Client-agnostic

---

### SectionBag (Layout Composition)

- Named layout sections
- Explicit population
- No capture or buffering

---

### Fragment → Section Targeting

- Fragments declare their target section
- Stable DOM selector convention
- HTMX / JS / SSE friendly

---

### Canonical URL Helpers

- Config-driven canonical URLs
- Path or query routing
- Template helpers

---

### Asset Manager

- Section-aware assets
- Explicit publishing
- No global state

---

### Server-Sent Events (SSE)

- Native SSE streaming
- Built on Response::stream
- HTML or data payloads
- HTMX compatible

Typical uses:
- live UI updates
- streaming AI output
- progress indicators

---

## Design Principles

All fun layers adhere to:

- explicit APIs
- zero magic
- PHP 5.6 compatibility
- opt-in usage
- predictable behavior