<?php
namespace boru\dweb\Cli;

class Args
{
    /** @var array key => value|array */
    public $flags = array();

    /** @var array positional args */
    public $pos = array();

    /**
     * Parse args list (already excluding the command name).
     *
     * Supports:
     *  --k=v
     *  --k v
     *  --flag (boolean true)
     *  -k v   (single-letter)
     *  -abc   (treated as -a -b -c = true)
     */
    public static function parse(array $args)
    {
        $a = new self();

        for ($i = 0; $i < count($args); $i++) {
            $cur = $args[$i];

            // long flag
            if (substr($cur, 0, 2) === '--') {
                $eq = strpos($cur, '=');
                if ($eq !== false) {
                    $k = substr($cur, 2, $eq - 2);
                    $v = substr($cur, $eq + 1);
                    $a->addFlag($k, $v);
                    continue;
                }

                $k = substr($cur, 2);

                // --k <next> or --k (true)
                if (($i + 1) < count($args) && substr($args[$i + 1], 0, 1) !== '-') {
                    $a->addFlag($k, $args[$i + 1]);
                    $i++;
                } else {
                    $a->addFlag($k, true);
                }
                continue;
            }

            // short flag(s)
            if (substr($cur, 0, 1) === '-' && strlen($cur) > 1) {
                // -k value
                if (strlen($cur) === 2) {
                    $k = substr($cur, 1, 1);
                    if (($i + 1) < count($args) && substr($args[$i + 1], 0, 1) !== '-') {
                        $a->addFlag($k, $args[$i + 1]);
                        $i++;
                    } else {
                        $a->addFlag($k, true);
                    }
                    continue;
                }

                // -abc => -a -b -c
                for ($j = 1; $j < strlen($cur); $j++) {
                    $a->addFlag(substr($cur, $j, 1), true);
                }
                continue;
            }

            // positional
            $a->pos[] = $cur;
        }

        return $a;
    }

    /**
     * Get flag value (if repeated, returns the last).
     */
    public function get($key, $default = null)
    {
        if (!array_key_exists($key, $this->flags)) return $default;

        $v = $this->flags[$key];
        if (is_array($v)) {
            return count($v) ? $v[count($v) - 1] : $default;
        }
        return $v;
    }

    /**
     * Get all values for a possibly repeated flag.
     *
     * @return array
     */
    public function getAll($key)
    {
        if (!array_key_exists($key, $this->flags)) return array();

        $v = $this->flags[$key];
        return is_array($v) ? $v : array($v);
    }

    public function has($key)
    {
        return array_key_exists($key, $this->flags);
    }

    private function addFlag($key, $value)
    {
        $key = (string)$key;

        if (!array_key_exists($key, $this->flags)) {
            $this->flags[$key] = $value;
            return;
        }

        // convert to list on repeat
        if (!is_array($this->flags[$key])) {
            $this->flags[$key] = array($this->flags[$key]);
        }

        $this->flags[$key][] = $value;
    }
}
