<?php
namespace boru\dweb\Cli\Commands;

use boru\dweb\Cli\CommandInterface;
use boru\dweb\Cli\Args;
use boru\dweb\Support\KernelEnv;

use boru\dweb\Smoke\SmokeRunner;
use boru\dweb\Smoke\SmokeContext;
use boru\dweb\Smoke\SmokeSuiteRegistry;

class SmokeTestCommand implements CommandInterface
{
    /** @var KernelEnv */
    private $env;

    public function __construct(KernelEnv $env = null)
    {
        $this->env = $env;
    }

    public function name() { return 'smoketest'; }

    public function description()
    {
        return 'Run smoke tests. Flags: --suite=all|name --filter=substr. Global: --env-bootstrap=..., --setEnv=...';
    }

    public function execute(array $args)
    {
        if (!$this->env) {
            fwrite(STDERR, "ERROR: smoketest requires env (use --env-bootstrap=...)\n");
            return 2;
        }

        $a = Args::parse($args);
        $suiteName = $a->get('suite', 'all');
        $filter    = $a->get('filter', null);

        $registry = $this->env->container()->get(SmokeSuiteRegistry::class);

        $runner = new SmokeRunner();

        $suiteNameLc = strtolower((string)$suiteName);
        if ($suiteNameLc === 'all') {
            foreach ($registry->all() as $suite) $suite->register($runner);
        } else {
            $suite = $registry->get($suiteNameLc);
            if (!$suite) {
                fwrite(STDERR, "Unknown suite: {$suiteName}\n");
                fwrite(STDERR, "Available: " . implode(', ', array_keys($registry->all())) . ", all\n");
                return 2;
            }
            $suite->register($runner);
        }

        $ctx = new SmokeContext(
            $this->env->config(),
            $this->env->container(),
            $this->env->routes(),
            $this->env->pipeline()
        );

        $result = $runner->runAll($ctx, $filter);

        foreach ($result->lines as $line) echo $line . "\n";
        echo "\nSummary: started={$result->started}, passed={$result->passed}, failed={$result->failed}\n";

        return $result->exitCode();
    }
}
