<?php
namespace boru\dweb\Contracts;

use boru\dweb\Kernel\Container;
use boru\dweb\Routing\RouteCollection;
use boru\dweb\Routing\ModuleRouteCollection;

interface ModuleInterface
{
    /** @return string */
    public function getName();

    /**
     * Register services/providers into the container.
     *
     * @param Container $container
     * @param SettingsInterface $settings
     * @return void
     */
    public function register(Container $container, SettingsInterface $settings);

    /**
     * Register routes (views + actions).
     *
     * @param ModuleRouteCollection $routes
     * @param Container $container
     * @param SettingsInterface $settings
     * @return void
     */
    public function routes(ModuleRouteCollection $routes, Container $container, SettingsInterface $settings);
}
