<?php
namespace boru\dweb\Contracts;

interface TemplateLocatorInterface
{
    /**
     * Registers a module's template base directory.
     * Example: /path/to/Modules/Skeleton/templates
     *
     * @param string $moduleName
     * @param string $templatesDir
     * @return void
     */
    public function registerModule($moduleName, $templatesDir);

    /**
     * Resolve a logical template id to a file path.
     *
     * Rules (locked):
     *  1) host override: <app_templates>/<Module>/<templateId>.<ext>
     *  2) module default: <module_templates>/<templateId>.<ext>
     *
     * @param string $moduleName
     * @param string $templateId like "dashboard/index" or "layouts/default"
     * @param string $extension like "php" or "tpl"
     * @return string|null
     */
    public function resolve($moduleName, $templateId, $extension);
}
